﻿namespace LightsOut.Helpers
{
    public static class BoundsCalculator
    {
        /// <summary>
        /// Helper method for calculating row coordinate with periodic boundary conditions
        /// </summary>
        /// <param name="row">Row index</param>
        /// <param name="rowCount">Number of rows</param>
        /// <returns></returns>
        public static int GetRow(int row, int rowCount)
        {
            if (row < 0)
            {
                return row + rowCount;
            }
            return row % rowCount;
        }

        /// <summary>
        /// Helper method for calculating column coordinate with periodic boundary conditions
        /// </summary>
        /// <param name="column">Coumn index</param>
        /// <param name="numberOfColumns">Number of columns</param>
        /// <returns></returns>
        public static int GetColumn(int column, int numberOfColumns)
        {
            if (column < 0)
            {
                return column + numberOfColumns;
            }
            return column % numberOfColumns; 
        }
    }
}
