﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Moq;
using prismMVVM.ViewModels;
using Microsoft.Practices.Prism.Mvvm;
using System.ComponentModel;


namespace prismMVVMUnitTest
{
    [TestClass]
    public class UnitTestViewModel
    {
        [TestMethod]
        public void ConstructorTest()
        {
            WidokViewModel widokViewModel = new WidokViewModel();
            Assert.IsNotNull(widokViewModel);
            Assert.IsNotNull(widokViewModel.AddCommand);
            Assert.IsNotNull(widokViewModel.CalculateCommand);
            Assert.IsNotNull(widokViewModel.ResetCommand);
        }

        [TestMethod]
        public void YearTest()
        {
            int expected = 1993;
            string actual = null;

            WidokViewModel widokViewModel = new WidokViewModel();
            widokViewModel.PropertyChanged += delegate(object sender, PropertyChangedEventArgs e)
            {
                actual = e.PropertyName;
            };
            widokViewModel.Year = expected;
            Assert.IsNotNull(actual);
            Assert.AreEqual(expected, widokViewModel.Year);
        }

        [TestMethod]
        public void CalcAgeTest()
        {
            int year = 1993;
            int actualYear = DateTime.Now.Year;
            WidokViewModel widokViewModel = new WidokViewModel();
            widokViewModel.Year = year;
            widokViewModel.CalcAge();
            Assert.AreEqual(actualYear - year, widokViewModel.Age);

            
        }
    }
}
