﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Practices.Prism.Mvvm;
using Microsoft.Practices.Prism.Commands;
using prismMVVM.Models;

namespace prismMVVM.ViewModels
{
    public class WidokViewModel : BindableBase
    {
        private int _year;
        private int _age;
        private string _color;
        private string _name;

        Person person = new Person();

        public DelegateCommand CalculateCommand { get; set; }
        public DelegateCommand ResetCommand { get; set; }
        public DelegateCommand AddCommand { get; set; }

        public string[] AllColors { get; set; }

        public WidokViewModel()
        {
            CalculateCommand = new DelegateCommand(CalcAge);
            ResetCommand = new DelegateCommand(Reset);
            AddCommand = new DelegateCommand(AddPerson);

            this.AllColors = new[] { "czerwony", "żółty", "zielony" };
        }

        public int Year
        {
            get
            {
                return _year;
            }
            set
            {
                SetProperty<int>(ref _year, value);
            }
        }


        public void AddPerson()
        {
            person.Year = _year;
            person.FavouriteColor = _color;
            person.Name = _name;

            Reset();
        }

        public void Reset()
        {
            Name = "";
            Color = "";
            Age = 0;
            Year = 0;
        }

        public int Age
        {
            get
            {
                return _age;
            }
            set
            {
                SetProperty<int>(ref _age, value);
            }
        }

        public void CalcAge()
        {
            person.Year = _year;
            Age = person.CalculateAge();
        }

        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                SetProperty(ref _name, value);
            }
        }

        public string Color
        {
            get
            {
                return _color;
            }
            set
            {
                SetProperty(ref _color, value);
            }
        }
    }
}
