﻿using Microsoft.Practices.Prism.Mvvm;
using Microsoft.Practices.Prism.Regions;
using ModuleA.Models;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ModuleA.ViewModels
{
    public class CatalogViewModel : BindableBase, INavigationAware
    {
		private ObservableCollection<Product> products;
        public ObservableCollection<Product> Products
		{
			get
			{
				return products;
			}
			protected set
			{
				SetProperty<ObservableCollection<Product>>(ref products, value);
			}
		}

        protected IProductRepository productsRepository;

        public CatalogViewModel(IProductRepository productsRepository)
        {
            this.productsRepository = productsRepository;
            this.Products = new ObservableCollection<Product>(this.productsRepository.GetAll());
        }

		public bool IsNavigationTarget(NavigationContext navigationContext)
		{
			return true;
		}

		public void OnNavigatedFrom(NavigationContext navigationContext)
		{
		}

		public void OnNavigatedTo(NavigationContext navigationContext)
		{
			this.Products = new ObservableCollection<Product>(this.productsRepository.GetAll());
		}
	}
}
