﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Practices.Prism.Modularity;
using Microsoft.Practices.Prism.Regions;
using Microsoft.Practices.Unity;
using ModuleA.Views;
using Services;

namespace ModuleA
{
	public class ModuleA : IModule
	{
		protected IRegionManager RegionManager { get; private set; }
		protected IUnityContainer Container { get; private set; }

		public ModuleA(IRegionManager regionManager, IUnityContainer container)
		{
			Container = container;
			RegionManager = regionManager;
		}

		public void Initialize()
		{
            Container.RegisterInstance<IProductRepository>(new HardcodedProductRepository());
            Container.RegisterType<IAuthority, SettingsAuthority>();

			Container.RegisterType<Object, EditorCatalog>(typeof(EditorCatalog).Name);
			Container.RegisterType<Object, Catalog>(typeof(Catalog).Name);

			RegionManager.RegisterViewWithRegion("MainRegion", GetModuleView);
            RegionManager.RegisterViewWithRegion("MenuRegionA", typeof(ButtonViewA));
		}

		public object GetModuleView()
		{
			var auth = Container.Resolve<IAuthority>();

			if (auth.IsEditor)
				return Container.Resolve<EditorCatalog>();
			else
				return Container.Resolve<Catalog>();
		}
	}
}
