﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using projekt05.Model;
using System;
using GalaSoft.MvvmLight.Messaging;

namespace projekt05.ViewModel
{
    public class MainViewModel : ViewModelBase
    {
        private Random rand = new Random();

        #region SecretNumber Property
        public const string SecretNumberPropertyName = "SecretNumber";
        private int _secretNumber = 0;

        public int SecretNumber
        {
            get
            {
                return _secretNumber;
            }

            set
            {
                if (_secretNumber == value)
                {
                    return;
                }

                _secretNumber = value;
                RaisePropertyChanged(SecretNumberPropertyName);
            }
        }
        #endregion

        #region Suggestion
        public const string SuggestionPropertyName = "Suggestion";
        private string _suggestion = "";

        public string Suggestion
        {
            get
            {
                return _suggestion;
            }

            set
            {
                if (_suggestion == value)
                {
                    return;
                }

                _suggestion = value;
                RaisePropertyChanged(SuggestionPropertyName);
            }
        }
        #endregion

        #region IsInProgress Property
        public const string IsInProgressPropertyName = "IsInProgress";
        private bool _isInProgress = false;

        public bool IsInProgress
        {
            get
            {
                return _isInProgress;
            }

            set
            {
                if (_isInProgress == value)
                {
                    return;
                }

                _isInProgress = value;
                RaisePropertyChanged(IsInProgressPropertyName);
            }
        }
        #endregion

        #region MaxRange Property
        /// <summary>
        /// The <see cref="MaxRange" /> property's name.
        /// </summary>
        public const string MaxRangePropertyName = "MaxRange";

        private int _maxRange = 10;

        public int MaxRange
        {
            get
            {
                return _maxRange;
            }

            set
            {
                if (_maxRange == value)
                {
                    return;
                }

                _maxRange = value;
                RaisePropertyChanged(MaxRangePropertyName);
            }
        }
        #endregion

        #region IsSolved Property
        public const string IsSolvedPropertyName = "IsSolved";
        private bool _isSolved = false;

        public bool IsSolved
        {
            get
            {
                return _isSolved;
            }

            set
            {
                if (_isSolved == value)
                {
                    return;
                }

                _isSolved = value;
                RaisePropertyChanged(IsSolvedPropertyName);
            }
        }
        #endregion

        #region Start
        private RelayCommand _startCommand;

        public RelayCommand Start
        {
            get
            {
                if (_startCommand == null)
                    _startCommand = new RelayCommand(initGuess);
                        return _startCommand;
            
                /*
                if (_startCommand == null)
                {
                    _startCommand = new RelayCommand(
                        () =>
                        {
                            SecretNumber = rand.Next(10) + 1;
                            IsSolved = false;
                            IsInProgress = true;
                            Suggestion = "";
                        }
                    );
                }
                */
                //return _startCommand;
            }       
        }
        #endregion

        #region CheckGuess Command
        private RelayCommand<int> _checkGuess;

        public RelayCommand<int> CheckGuess
        {
            get
            {
                if(_checkGuess == null)
                    _checkGuess = new RelayCommand<int>(
                        x =>
                        {
                            if (x == _secretNumber)
                            {
                                IsInProgress = false;
                                IsSolved = true;
                            }
                            else if (x < _secretNumber)
                                Suggestion = "Liczba jest za mala.";
                            else if (x > _secretNumber)
                                Suggestion = "Liczba jest za duza.";
                        });

                return _checkGuess;                   
            }
        }
        #endregion

        public MainViewModel()
        {
            Messenger.Default.Register<Messages.ChangeOptionsMessage>(this, HandleChangeOptions);
        }

        private void HandleChangeOptions(Messages.ChangeOptionsMessage m)
        {
            this.MaxRange = m.MaxRange;
            initGuess();
        }

        private void initGuess()
        {
            SecretNumber = rand.Next(MaxRange) + 1;
            IsSolved = false;
            IsInProgress = true;
            Suggestion = "";
        }

        ////public override void Cleanup()
        ////{
        ////    // Clean up if needed

        ////    base.Cleanup();
        ////}
    }
}