﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using prismMVVM.ViewModels;
using System.ComponentModel;

namespace prismMVVM.Tests
{
    [TestClass]
    public class WidokViewModelTest
    {
        [TestMethod]
        public void ConstructorTest()
        {
            //Arrange
            WidokViewModel widokViewModel = new WidokViewModel();
            Assert.IsNotNull(widokViewModel);
            Assert.IsNotNull(widokViewModel.AddCommand);
            Assert.IsNotNull(widokViewModel.CalculateCommand);
            Assert.IsNotNull(widokViewModel.ResetCommand);
        }

        [TestMethod]
        public void YearTest()
        {
            //Arrange
            string actual = null;
            int expected = 1993;

            WidokViewModel widokViewModel = new WidokViewModel();
            widokViewModel.PropertyChanged += delegate(object sender, PropertyChangedEventArgs e)
            {
                actual = e.PropertyName;
            };
            

            //Act
            widokViewModel.Year = expected;

            //Assert
            Assert.IsNotNull(actual);
            Assert.AreEqual("Year", actual);
            Assert.AreEqual(expected, widokViewModel.Year);
            
        }
    }
}
