﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using System.Text.RegularExpressions; //RegEx

namespace WyrazeniaRegularne.Controllers
{
    public class DopasowaniaController : Controller
    {
        static List<String> listaWyrazenDoSprawdzenia = new List<String>();
        static List<String> wyrazeniaPasujaceDoWzorca = new List<String>();

        public ActionResult Index(string wzorzec)
        {
            ViewData["ListaWYrazenDoSprawdzenia"] = new MultiSelectList(listaWyrazenDoSprawdzenia, wyrazeniaPasujaceDoWzorca);
            ViewData["Wzorzec"] = wzorzec;
            return View();
        }

        [HttpPost]
        public ActionResult DodajElementDoSprawdzenia(FormCollection form)
        {
            if (form != null)
                listaWyrazenDoSprawdzenia.Add(form["ElementDoSprawdzenia"].ToString());
            return RedirectToAction("Index");
        }

        [HttpPost]
        public ActionResult WyczyscListe()
        {
            listaWyrazenDoSprawdzenia.Clear();
            wyrazeniaPasujaceDoWzorca.Clear();
            return RedirectToAction("Index");
        }

        [HttpPost]
        public ActionResult SprawdzDopasowania(FormCollection form)
        {
            string wzorzec = form["Wzorzec"].ToString();
            if (listaWyrazenDoSprawdzenia.Count() > 0 && !String.IsNullOrEmpty(wzorzec))
            {
                wyrazeniaPasujaceDoWzorca.Clear();
                foreach (string wyrażenie in listaWyrazenDoSprawdzenia)
                {
                    if (Regex.IsMatch(wyrażenie, wzorzec))
                    {
                        wyrazeniaPasujaceDoWzorca.Add(wyrażenie);
                    }
                }
            }
            return RedirectToAction("Index");
        }
    }
}
