﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Nawigacja.Models;

namespace Nawigacja.Controllers
{
    public class MapaController : Controller
    {
        static NawigacjaEntities entities = new NawigacjaEntities();

        //
        // GET: /Mapa/

        public ActionResult Index()
        {
            return View();
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Index(FormCollection formularz)
        {
            if (ModelState.IsValid)
            {
                int idNowejTrasy = 0;
                if (entities.Table.Count() > 0)
                {
                    idNowejTrasy = (from adres in entities.Table
                                    where adres.IdTrasy != null
                                    select adres.IdTrasy).Max();
                }
                ++idNowejTrasy;                
                
                /*
                Table nowaTrasa = Table.CreateTable(idNowejTrasy);
                nowaTrasa.MiejsceWyjazdu = formularz["miejsceWyjazdu"].ToString();
                nowaTrasa.MiejsceDocelowe = formularz["miejsceDocelowe"].ToString();
                nowaTrasa.DataDodania = DateTime.Now;                
                */
                Table nowaTrasa = Table.CreateTable(idNowejTrasy, formularz["miejsceWyjazdu"].ToString(), formularz["miejsceDocelowe"].ToString(), DateTime.Now); //gdy nie ma AllowNull w tabeli

                entities.AddToTable(nowaTrasa);
                entities.SaveChanges(System.Data.Objects.SaveOptions.AcceptAllChangesAfterSave);
                return View(nowaTrasa);
            }
            return View();
        }

        public ActionResult WyswietlTrasy()
        {
            return View("Trasy", entities);
        }

        public ActionResult UsunTrase(Table adres)
        {
            if (entities.Table.Count() > 0)
            {
                Table trasaDoUsuniecia = entities.Table.Where(s => s.IdTrasy == adres.IdTrasy).First();
                entities.Table.DeleteObject(trasaDoUsuniecia);
                entities.SaveChanges(System.Data.Objects.SaveOptions.AcceptAllChangesAfterSave);
            }
            return View("Trasy", entities);
        }
    }
}
