﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using Renci.SshNet;
using System.IO;

namespace Ssh
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private SshClient sshClient = null;

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            if(sshClient==null) sshClient = new SshClient("zoobato.pl", 22, "test", "qwerty");

            if (sshClient.IsConnected)
            {
                sshClient.Disconnect();
                btnPolacz.Content = "Połącz";
                lbLogin.Content = "Login:";
                lbKernel.Content = "Login:";
                lvLista.Items.Clear();
            }
            else
            {
                sshClient.Connect();
                if (sshClient.IsConnected)
                {
                    btnPolacz.Content = "Rozłącz";

                    SshCommand polecenie = sshClient.RunCommand("whoami");
                    lbLogin.Content += " " + polecenie.Result;
                    
                    polecenie = sshClient.RunCommand("uname -r");
                    lbKernel.Content += " " + polecenie.Result;

                    wyswietlPliki();
                }
            }
        }

        private void wyswietlPliki()
        {
            if (sshClient == null || !sshClient.IsConnected)
            {
                MessageBox.Show("Brak połączenia");
                return;
            }

            lvLista.Items.Clear();
            //SshCommand polecenie = sshClient.RunCommand("cd dotnet && ls -la | awk '{print $9}'");
            SshCommand polecenie = sshClient.RunCommand("cd dotnet && ls");
            String[] listaNazwPlikow = polecenie.Result.Split('\n');
            foreach (String nazwaPliku in listaNazwPlikow) lvLista.Items.Add(nazwaPliku);
            lbStatus.Content += " " + polecenie.ExitStatus.ToString();

            //to lepiej zrobić sftpClient.ListDirectory() (zob. niżej)
        }

        private void wyswietlPlikiSftp(SftpClient sftpClient)
        {
            lvLista.Items.Clear();
            foreach (Renci.SshNet.Sftp.SftpFile plik in sftpClient.ListDirectory(".")) lvLista.Items.Add(plik.Name);
        }

        private SftpClient sftpClient;
        private void Button_Click_2(object sender, RoutedEventArgs e)
        {
            if (sshClient == null || !sshClient.IsConnected)
            {
                MessageBox.Show("Brak połączenia");
                return;
            }

            Microsoft.Win32.OpenFileDialog dlg = new Microsoft.Win32.OpenFileDialog();
            bool? wynik = dlg.ShowDialog();
            if (wynik.Value)
            {
                String nazwaPliku = dlg.FileName;
                sftpClient = new SftpClient(sshClient.ConnectionInfo);
                sftpClient.Connect();
                sftpClient.ChangeDirectory("dotnet");

                //synchroniczne wysylanie
                Stream fs = File.OpenRead(nazwaPliku);
                sftpClient.UploadFile(fs,nazwaPliku.Split('\\').Last());
                wyswietlPlikiSftp(sftpClient);
                sftpClient.Disconnect();
                fs.Close();

                //wyswietlPliki();
            }
        }

        private void Button_Click_3(object sender, RoutedEventArgs e)
        {
            if (sshClient != null || !sshClient.IsConnected)
            {
                MessageBox.Show("Brak połączenia");
                return;
            }

            Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();
            bool? wynik = dlg.ShowDialog();
            if (wynik.Value)
            {
                String nazwaPlikuLokalnie = dlg.FileName;
                String nazwaPlikuZdalnie = lvLista.SelectedItem.ToString();

                sftpClient = new SftpClient(sshClient.ConnectionInfo);
                sftpClient.Connect();
                sftpClient.ChangeDirectory("dotnet");

                //asynchroniczne pobieranie
                Stream fs = File.Create(nazwaPlikuLokalnie);
                IAsyncResult sftpWynik = sftpClient.BeginDownloadFile(nazwaPlikuZdalnie, fs);
                while (!sftpWynik.IsCompleted) lbStatus.Content = "Pobieranie: " + (sftpWynik as Renci.SshNet.Sftp.SftpDownloadAsyncResult).DownloadedBytes / 1024 + " kb";
                sftpClient.EndDownloadFile(sftpWynik);
                MessageBox.Show("Pobrałem " + (sftpWynik as Renci.SshNet.Sftp.SftpDownloadAsyncResult).DownloadedBytes / 1024 + " kb");
                fs.Close();
                sftpClient.Disconnect();
            }
        }

        private void Button_Click_4(object sender, RoutedEventArgs e)
        {
            if (sshClient==null || !sshClient.IsConnected)
            {
                MessageBox.Show("Brak połączenia");
                return;
            }

            String nazwaPlikuZdalnie = lvLista.SelectedItem.ToString();

            /* NIE DZIAŁA!!!!            
            SshCommand polecenie = sshClient.RunCommand("cd dotnet && rm -rf " + nazwaPlikuZdalnie);
            lbStatus.Content += " " + polecenie.ExitStatus.ToString();
            wyswietlPliki();
            */

            sftpClient = new SftpClient(sshClient.ConnectionInfo);
            sftpClient.Connect();
            sftpClient.ChangeDirectory("dotnet");
            sftpClient.DeleteFile(nazwaPlikuZdalnie);
            wyswietlPlikiSftp(sftpClient);
            sftpClient.Disconnect();
        }

        private void Button_Click_5(object sender, RoutedEventArgs e)
        {
            if (sshClient==null || !sshClient.IsConnected)
            {
                MessageBox.Show("Brak połączenia");
                return;
            }

            Stream input = new MemoryStream(); //puste wejście
            Stream output = new MemoryStream();
            Stream outputEx = new MemoryStream();
            Shell powloka = sshClient.CreateShell(input,output,outputEx);            
            powloka.Start();
            System.Threading.Thread.Sleep(100);
            //powloka.Stop();
            
            output.Position = 0;
            StreamReader tr = new StreamReader(output);
            string s;
            while ((s = tr.ReadLine()) != null)
            {
                lbPowloka.Items.Add(s);
            }
            lbStatus.Content = "Pobieranie outputu powłoki zakończone";
        }
    }
}
