﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Microsoft.Live;
using Windows.Storage;
using Windows.Storage.Pickers;
using Windows.Storage.Pickers.Provider;
using System.Threading;
// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace skydrivekurs2
{


    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        private LiveLoginResult authResult;
        private LiveConnectClient liveClient;
        private StorageFile _file;
        public MainPage()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            Login();
        }

        public async void Login()
        {
            LiveAuthClient Client = new LiveAuthClient();
            authResult = await Client.LoginAsync(new List<string>() { "wl.basic", "wl.skydrive", "wl.skydrive_update" });
            if (authResult.Status == LiveConnectSessionStatus.Connected)
            {
                liveClient = new LiveConnectClient(authResult.Session);
                LiveOperationResult liveResult = await liveClient.GetAsync("me");
                dynamic result = liveResult.Result;
                txtImie.Text = result.name;
            }
        }

        public class SkyDriveFile
        {
            public string ID {get; set;}
            public string Name { get; set; }
            public string Type { get; set; }
            public string Link { get; set; }
            public DateTime Date { get; set; }

            public SkyDriveFile(dynamic fileData)
            {
                Name = fileData.name;
                Type = fileData.type;
                ID = fileData.id;
                Link = fileData.link;
                Date = Convert.ToDateTime(fileData.created_time);
            }
        
        }

        private CancellationTokenSource cts;
        private async void btnLista_Click(object sender, RoutedEventArgs e)
        {
            cts = new CancellationTokenSource();
            LiveOperationResult result= await liveClient.GetAsync("me/skydrive/files", cts.Token);
            var fileList = new List<SkyDriveFile>();
            dynamic data = result.Result;
            foreach (var tmp in data)
            {
                foreach (var tmp2 in tmp.Value)
                {
                    fileList.Add(new SkyDriveFile(tmp2));
                }
            }
            lvFiles.ItemsSource = fileList;
        }

        private async void btnUpload_Click(object sender, RoutedEventArgs e)
        {
            if (_file == null) return;
            pb.Value = 0;
            var progressHandler = new Progress<LiveOperationProgress>((progress) => { pb.Value = progress.ProgressPercentage; });

            var stream = await _file.OpenStreamForReadAsync();
            cts = new CancellationTokenSource();
            LiveOperationResult result = await liveClient.BackgroundUploadAsync("me/skydrive", _file.Name, stream.AsInputStream(), OverwriteOption.Overwrite, cts.Token, progressHandler);
        }

        private async void btnFile_Click(object sender, RoutedEventArgs e)
        {
            var fp = new FileOpenPicker();
            fp.ViewMode = PickerViewMode.List;
            fp.SuggestedStartLocation = PickerLocationId.DocumentsLibrary;
            fp.FileTypeFilter.Add(".jpg");
            var file = await fp.PickSingleFileAsync();
            if (file != null)
            {
                _file = file;
            }
            else
            {
                _file = null;
            }

        }

        private async void btnDwnl_Click(object sender, RoutedEventArgs e)
        {
            pb.Value = 0;
            var progressHandler = new Progress<LiveOperationProgress>((progress) => { pb.Value = progress.ProgressPercentage; });
            var file = lvFiles.SelectedItem as SkyDriveFile;
            LiveDownloadOperationResult result = await liveClient.BackgroundDownloadAsync(string.Format("{0}/content", file.ID), cts.Token, progressHandler);
            var stream = await result.GetRandomAccessStreamAsync();
            var tmp = Windows.Storage.ApplicationData.Current.TemporaryFolder;
            var localFile = await tmp.CreateFileAsync(file.Name,CreationCollisionOption.GenerateUniqueName);
            var fileStream = await localFile.OpenStreamForWriteAsync();
            await stream.AsStreamForRead().CopyToAsync(fileStream);
            await fileStream.FlushAsync();
            fileStream.Dispose();
            stream.Dispose();

        }

        private async void btnCreate_Click(object sender, RoutedEventArgs e)
        {
            var folderDAta = new Dictionary<string, object>();
            folderDAta.Add("name", "nowy folder skydrive");
            liveClient = new LiveConnectClient(authResult.Session);
            LiveOperationResult result = await liveClient.PostAsync("me/skydrive", folderDAta);
            dynamic result2 = result.Result;

        }

        private async void btnDelete_Click(object sender, RoutedEventArgs e)
        {
            liveClient = new LiveConnectClient(authResult.Session);
            var file = lvFiles.SelectedItem as SkyDriveFile;
            LiveOperationResult result = await liveClient.DeleteAsync(file.ID);

        }



    }
}
