﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Net;
using HtmlAgilityPack;

namespace crawler
{
    public partial class Form1 : Form
    {
        /// <summary>
        /// Random.
        /// </summary>
        public static Random random = new Random();

        /// <summary>
        /// Threads cout.
        /// </summary>
        public static int threadsCount = 10;

        /// <summary>
        /// Event wait handlers.
        /// </summary>
        public static List<EventWaitHandle> ewh = new List<EventWaitHandle>();

        /// <summary>
        /// Frontier limit.
        /// </summary>
        public static int frontierSize = 100;

        /// <summary>
        /// Frontier.
        /// </summary>
        //public static Queue<Page> frontier = new Queue<Page>(frontierSize);
        public static Queue<string> frontier = new Queue<string>(frontierSize);

        /// <summary>
        /// Visited.
        /// </summary>
        //public static BindingList<Page> visited = new BindingList<Page>();
        public static BindingList<string> visited = new BindingList<string>();

        // ~

        /// <summary>
        /// Constructor.
        /// </summary>
        public Form1()
        {
            InitializeComponent();

            stopButton.Enabled = false;
        }

        // ~

        /// <summary>
        /// Crawl button.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void crawlButton_Click(object sender, EventArgs e)
        {
            string uriString = pageUri.Text;

            if (uriString != String.Empty)
            {
                Uri root = new Uri(uriString);
                Page rootPage = new Page() { Uri = root };

                frontier.Enqueue(rootPage.Uri.ToString());

                startThreads();
            }
        }

        private void startThreads()
        {
            crawlButton.Enabled = false;
            stopButton.Enabled = true;

            for (int i = 0, iCounter = threadsCount; i < iCounter; i++)
            {
                EventWaitHandle tmpEwh = new ManualResetEvent(false);
                //tmpEwh.Set();

                //ewh[i] = tmpEwh;
                ewh.Add(tmpEwh);

                lock (threadsGrid)
                {
                    //if (true == threadsGrid.InvokeRequired)
                    //{
                        threadsGrid.Invoke((Action)(() =>
                        {
                            string[] data = new string[] { "Operacja", String.Format("Uruchomiono {0} wątek.", i) };
                            threadsGrid.Rows.Add(data);

                            threadsGrid.Update();
                        }));

                    //}
                }

                ThreadPool.QueueUserWorkItem(crawl, i);

            }

            //EventWaitHandle[] ewha = ewh.ToArray();
            //WaitHandle.WaitAll(ewha);
        }

        /// <summary>
        /// Stop button.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void stopButton_Click(object sender, EventArgs e)
        {
            crawlButton.Enabled = true;
            stopButton.Enabled = false;
            // ewh[0].Reset();

            for (int i = 0, iCounter = threadsCount; i < iCounter; i++)
            {
                EventWaitHandle tmpEwh = ewh[i];
                tmpEwh.Close();

                lock (threadsGrid)
                {
                    //if (true == threadsGrid.InvokeRequired)
                    //{
                        threadsGrid.Invoke((Action)(() =>
                        {
                            string[] data = new string[] { "Wątek", String.Format("Zatrzymano {0} wątek.", i) };
                            threadsGrid.Rows.Add(data);

                            threadsGrid.Update();
                        }));

                    //}
                }
            }

            //requestsGrid.Rows.Clear();
            //resultsGrid.Rows.Clear();
            //threadsGrid.Rows.Clear();
        }

        /// <summary>
        /// Reset button.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void resetButton_Click(object sender, EventArgs e)
        {
            crawlButton.Enabled = true;
            stopButton.Enabled = false;
            // ewh[0].Reset();

            for (int i = 0, iCounter = threadsCount; i < iCounter; i++)
            {
                EventWaitHandle tmpEwh = ewh[i];
                tmpEwh.Reset();

                lock (threadsGrid)
                {
                    //if (true == threadsGrid.InvokeRequired)
                    //{
                        threadsGrid.Invoke((Action)(() =>
                        {
                            string[] data = new string[] { "Wątek", String.Format("Zresetowano {0} wątek.", i) };
                            threadsGrid.Rows.Add(data);

                            threadsGrid.Update();
                        }));
                    //}
                }
            }

            //requestsGrid.Rows.Clear();
            //resultsGrid.Rows.Clear();
            //threadsGrid.Rows.Clear();
        }

        // ~

        /// <summary>
        /// Crawl thread.
        /// </summary>
        /// <param name="o"></param>
        private void crawl(object o = null)
        {
            int ewhIndex = (int)o;

            if (ewh.Count < ewhIndex)
            {
                throw new Exception();
            }

            string currentThreadId = Thread.CurrentThread.ManagedThreadId.ToString();

            while (frontier.Count > 0)
            //if (frontier.Count > 0)
            {
                lock (frontier)
                {
                    //Page currentPage = frontier.Dequeue();
                    string currentPage = frontier.Dequeue();

                    //HttpWebRequest request = WebRequest.Create(currentPage.Uri) as HttpWebRequest;
                    HttpWebRequest request = WebRequest.Create(currentPage) as HttpWebRequest;

                    // Here is place where proxy, user agent, etc. manipulation takes place.
                    // For now, thats should work.
                    request.UserAgent = @"Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5";
                    //request.AllowAutoRedirect = true;
                    request.Timeout = 1000;

                    lock (requestsGrid)
                    {
                        if (true == requestsGrid.InvokeRequired)
                        {
                            requestsGrid.Invoke((Action)(() =>
                            {
                                string[] data = new string[] { "Wysłanie zapytania", currentPage, request.UserAgent };
                                requestsGrid.Rows.Add(data);

                                //visitedGrid.DataSource = visited.ToList();
                                visitedGrid.Update();
                            }));
                        }
                    }

                    try
                    {
                        HttpWebResponse response = request.GetResponse() as HttpWebResponse;

                        if (response.ContentType.StartsWith("text/html", StringComparison.InvariantCultureIgnoreCase))
                        {
                            lock (visited)
                            {
                                visited.Add(currentPage);
                            }

                            HtmlAgilityPack.HtmlDocument htmlDocument = new HtmlAgilityPack.HtmlDocument();
                            htmlDocument.Load(response.GetResponseStream());

                            HtmlNodeCollection metas = htmlDocument.DocumentNode.SelectNodes(@"//meta");
                            HtmlNodeCollection links = htmlDocument.DocumentNode.SelectNodes(@"//a[@href]");

                            foreach (HtmlNode link in links)
                            {
                                HtmlAttribute hrefAttribute = link.Attributes["href"];

                                if (hrefAttribute == null)
                                {
                                    continue;
                                }

                                string hrefAttributeValue = hrefAttribute.Value;

                                if (true == hrefAttributeValue.StartsWith("javascript", StringComparison.InvariantCultureIgnoreCase))
                                {
                                    continue;
                                }

                                Uri nextUri = new Uri(hrefAttributeValue, UriKind.RelativeOrAbsolute);

                                if (false == nextUri.IsAbsoluteUri)
                                {
                                    Uri currentUri = new Uri(currentPage);
                                    //nextUri = new Uri(currentPage.Uri, nextUri);
                                    //nextUri = new Uri(currentPage, nextUri.ToString());
                                    nextUri = new Uri(currentUri, nextUri);
                                }

                                Page nextPage = new Page() { Uri = nextUri };

                                bool a = frontier.Contains(nextPage.Uri.ToString());
                                bool b = visited.Contains(nextPage.Uri.ToString());

                                if (false == a && false == b)
                                {
                                    frontier.Enqueue(nextPage.Uri.ToString());
                                }
                            }
                        }

                    }
                    catch (Exception)
                    {
                        //
                    }

                }

                lock (visitedGrid)
                {
                    if (true == visitedGrid.InvokeRequired)
                    {
                        visitedGrid.Invoke((Action)(() =>
                        {
                            visitedGrid.Rows.Clear();

                            //foreach (Page visitedPage in visited)
                            foreach (string visitedPage in visited)
                            {
                                //string[] data = new string[] { visitedPage.GetType().ToString(), visitedPage.Uri.ToString() };
                                string[] data = new string[] { "", visitedPage };
                                visitedGrid.Rows.Add(data);
                            }

                            //visitedGrid.DataSource = visited.ToList();
                            visitedGrid.Update();
                        }));
                    }
                }

                lock (frontierGrid)
                {
                    if (true == frontierGrid.InvokeRequired)
                    {
                        frontierGrid.Invoke((Action)(() =>
                        {
                            frontierGrid.Rows.Clear();

                            //foreach (Page frontierPage in frontier)
                            foreach (string frontierPage in frontier)
                            {
                                //string[] data = new string[] { frontierPage.GetType().ToString(), frontierPage.Uri.ToString() };
                                string[] data = new string[] { "", frontierPage };
                                frontierGrid.Rows.Add(data);
                            }

                            //frontierGrid.DataSource = frontier.ToList();
                            frontierGrid.Update();
                        }));
                    }
                }

                lock (resultsGrid)
                {
                    if (true == resultsGrid.InvokeRequired)
                    {
                        resultsGrid.Invoke((Action)(() =>
                        {
                            resultsGrid.Rows.Clear();

                            string[] rowData1 = new string[] { "Ilość odwiedzonych", visited.Count.ToString() };
                            string[] rowData2 = new string[] { "Rozmiar frontier'u", frontier.Count.ToString() };

                            resultsGrid.Rows.Add(rowData1);
                            resultsGrid.Rows.Add(rowData2);

                            //frontierGrid.DataSource = frontier.ToList();
                            resultsGrid.Update();
                        }));
                    }
                }

                //return;

                try
                {
                    EventWaitHandle taskEwh = ewh[ewhIndex];
                    taskEwh.Set();
                }
                catch (Exception e)
                {
                    //
                }
            }

            return;
        }

    }
}
