﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.UI.Xaml.Shapes;
using Windows.UI;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace App2
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
        }

        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            //StackPanel myStackPanel = new StackPanel();
            Grid myGrid = new Grid();

            //im1(myGrid); // gryzdoły
            im2(myGrid); // domek
            //im3(myGrid); // gwiazdy na 11 pkt
            //im4(myGrid); // gwiazdy na 6 pkt
            

            this.Content = myGrid;
        }

        #region SHAPES

        void DrawLine(Grid p, Point start, Point end, SolidColorBrush color, double thickness)
        {
            Line line = new Line();
            line.X1 = start.X; 
            line.Y1 = start.Y;
            line.X2 = end.X;
            line.Y2 = end.Y;
            line.Stroke = color;
            line.StrokeThickness = thickness;

            p.Children.Add(line);
        }

        void DrawRectangle(Grid p,Thickness position, double height, double width, SolidColorBrush fill, SolidColorBrush stroke, double thickness)
        {
            Rectangle rect = new Rectangle();
            rect.HorizontalAlignment = HorizontalAlignment.Left;
            rect.VerticalAlignment = VerticalAlignment.Top;
            rect.Margin = position;
            rect.Width = width;
            rect.Height = height;
            rect.Stroke = stroke;
            rect.Fill = fill;
            rect.StrokeThickness = thickness;
            
            p.Children.Add(rect);
        }

        void DrawTextBlock(Grid p, double height, Thickness thickness, string text)
        {
            TextBlock textB = new TextBlock();
            textB.Height = height;
            textB.HorizontalAlignment = HorizontalAlignment.Left;
            textB.Margin = thickness;
            textB.Text = text;
            
            p.Children.Add(textB);
        }

        void DrawEllipse(Grid p, Thickness position, double height, double width, SolidColorBrush fill, SolidColorBrush stroke, double thickness)
        {
            Ellipse el = new Ellipse();
            el.Fill = fill;
            el.StrokeThickness = thickness;
            el.Stroke = stroke;
            el.Width = width;
            el.Height = height;
            el.Margin = position;

            p.Children.Add(el);
        }

        void DrawPolygon(Grid p, SolidColorBrush fill, SolidColorBrush stroke, double thickness, int numberOfpoints, Point[] pts)
        {
            Polygon polygon = new Polygon();
            polygon.Stroke = stroke;
            polygon.StrokeThickness = thickness;
            polygon.Fill = fill;
            for (int i = 0; i < numberOfpoints; i++)
            {
                polygon.Points.Add(pts[i]);
            }

            p.Children.Add(polygon);
        }

        void DrawPolyline(Grid p, SolidColorBrush stroke, double thickness, int numberOfpoints, Point[] pts)
        {
            Polyline polyline = new Polyline();
            polyline.Stroke = stroke;
            polyline.StrokeThickness = thickness;
            for (int i = 0; i < numberOfpoints; i++)
            {
                polyline.Points.Add(pts[i]);
            }

            p.Children.Add(polyline);
        }

        #endregion SHAPES

        #region IMAGES

        void im1(Grid myGrid)
        {
            myGrid.Background = new SolidColorBrush(Colors.DarkOliveGreen);

            DrawLine(myGrid, new Point(10, 10), new Point(200, 200), new SolidColorBrush(Colors.Aqua), 5);
            DrawLine(myGrid, new Point(500, 100), new Point(200, 700), new SolidColorBrush(Colors.Azure), 6);

            DrawRectangle(myGrid, new Thickness(10, 10, 0, 0), 100, 100, new SolidColorBrush(Colors.Bisque), new SolidColorBrush(Colors.Blue), 10);
            DrawRectangle(myGrid, new Thickness(100, 210, 0, 0), 340, 100, new SolidColorBrush(Colors.Brown), new SolidColorBrush(Colors.BurlyWood), 7);

            //DrawTextBlock(myGrid, 100, new Thickness(500, 100, 0, 0), "to jest testowy tekst");
            //DrawTextBlock(myGrid, 100, new Thickness(650, 50, 0, 0), "to jest testowy tekst numer 2");

            DrawEllipse(myGrid, new Thickness(300, 400, 0, 0), 40, 60, new SolidColorBrush(Colors.DimGray), new SolidColorBrush(Colors.DodgerBlue), 5);
            DrawEllipse(myGrid, new Thickness(400, 500, 0, 0), 100, 100, new SolidColorBrush(Colors.Firebrick), new SolidColorBrush(Colors.FloralWhite), 10);

            Point[] pts;
            pts = new Point[4];
            pts[0] = new Point(400, 10);
            pts[1] = new Point(500, 80);
            pts[2] = new Point(600, 120);
            pts[3] = new Point(100, 90);

            //DrawPolygon(myGrid, new SolidColorBrush(Colors.LemonChiffon), new SolidColorBrush(Colors.LightBlue), 9, 4, pts);
            DrawPolyline(myGrid, new SolidColorBrush(Colors.LemonChiffon), 9, 4, pts);


        }

        void im2(Grid myGrid)
        {
            myGrid.Background = new SolidColorBrush(Colors.CadetBlue);
            DrawEllipse(myGrid, new Thickness(0, 500, 0, 0), 1000, 1366, new SolidColorBrush(Colors.Green), new SolidColorBrush(Colors.DarkGreen), 5);
            DrawRectangle(myGrid, new Thickness(400, 250, 0, 0), 350, 500, new SolidColorBrush(Colors.WhiteSmoke), new SolidColorBrush(Colors.Silver), 5);
            DrawRectangle(myGrid, new Thickness(565, 400, 0, 0), 200, 140, new SolidColorBrush(Colors.BurlyWood), new SolidColorBrush(Colors.DarkKhaki), 5);
            DrawRectangle(myGrid, new Thickness(435, 400, 0, 0), 100, 100, new SolidColorBrush(Colors.Chartreuse), new SolidColorBrush(Colors.DarkKhaki), 5);
            DrawRectangle(myGrid, new Thickness(725, 400, 0, 0), 100, 100, new SolidColorBrush(Colors.Chartreuse), new SolidColorBrush(Colors.DarkKhaki), 5);
            
            Point[] pts;
            pts = new Point[4];
            pts[0] = new Point(350, 248);
            pts[1] = new Point(950, 248);
            pts[2] = new Point(650, 100);
            pts[3] = new Point(350, 248);
            DrawPolygon(myGrid, new SolidColorBrush(Colors.Red), new SolidColorBrush(Colors.DarkRed), 5, 4, pts);

            DrawLine(myGrid, new Point(580, 500), new Point(605, 500), new SolidColorBrush(Colors.Black), 4);
        }

        void im3(Grid myGrid)
        {
            Point[] pts;
            pts = new Point[11];
            pts[0] = new Point(840, 160);
            pts[1] = new Point(890, 300);
            pts[2] = new Point(1060, 300);
            pts[3] = new Point(930, 390);
            pts[4] = new Point(980, 535);
            pts[5] = new Point(840, 450);
            pts[6] = new Point(705, 535);
            pts[7] = new Point(755, 390);
            pts[8] = new Point(621, 300);
            pts[9] = new Point(790, 300);
            pts[10] = new Point(840, 160);
            DrawPolygon(myGrid, new SolidColorBrush(Colors.Gold), new SolidColorBrush(Colors.Goldenrod), 5, 11, pts);

            Point[] pts1;
            pts1 = new Point[11];
            pts1[0] = new Point(340, 160);
            pts1[1] = new Point(390, 300);
            pts1[2] = new Point(560, 300);
            pts1[3] = new Point(430, 390);
            pts1[4] = new Point(580, 535);
            pts1[5] = new Point(340, 450);
            pts1[6] = new Point(205, 535);
            pts1[7] = new Point(255, 390);
            pts1[8] = new Point(121, 300);
            pts1[9] = new Point(290, 300);
            pts1[10] = new Point(340, 160);
            DrawPolyline(myGrid, new SolidColorBrush(Colors.IndianRed), 5, 11, pts1);
        }

        void im4(Grid myGrid)
        {
            Point[] pts;
            pts = new Point[6];
            pts[0] = new Point(840, 160);
            pts[1] = new Point(980, 535);
            pts[2] = new Point(621, 300);
            pts[3] = new Point(1060, 300);
            pts[4] = new Point(705, 535);
            pts[5] = new Point(840, 160);

            DrawPolygon(myGrid, new SolidColorBrush(Colors.Gold), new SolidColorBrush(Colors.Goldenrod), 5, 6, pts);

            Point[] pts1;
            pts1 = new Point[6];
            pts1[0] = new Point(340, 160);
            pts1[1] = new Point(580, 535);
            pts1[2] = new Point(121, 300);
            pts1[3] = new Point(560, 300);
            pts1[4] = new Point(205, 535);
            pts1[5] = new Point(340, 160);
            
            DrawPolyline(myGrid, new SolidColorBrush(Colors.LavenderBlush), 5, 6, pts1);
        }

        #endregion IMAGES
    }
}
