﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

using Windows.Networking;
using Windows.Networking.Sockets;
using Windows.Storage.Streams;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace komunikatorUDP
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
            listener();
        }

        private async void listener()
        {
            DatagramSocket listener = new DatagramSocket();
            listener.MessageReceived += MessegeR;
            await listener.BindServiceNameAsync("10000");
        }

        void MessegeR(DatagramSocket socket, DatagramSocketMessageReceivedEventArgs eventArguments)
        {
            DataReader reader = new DataReader(eventArguments.GetDataStream());
            uint r = reader.ReadUInt32();
            string messege = reader.ReadString(r);
            logTextBlock.Text += messege + "\r\n";
        }
       
        private async void sendButton_Click(object sender, RoutedEventArgs e)
        {
            DatagramSocket send = new DatagramSocket();
            HostName ip = new HostName(hostTextBox.Text);
            await send.ConnectAsync(ip, "20000");
            DataWriter writer = new DataWriter(send.OutputStream);
            writer.WriteString(nickTextBox.Text + ": " + messageTextBox.Text + "\n");
            await writer.StoreAsync();
            logTextBlock.Text += nickTextBox.Text + ": " + messageTextBox.Text + "\r\n";
            messageTextBox.Text = "";
        }
        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
        }
    }
}
