﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

using MandelbrotPCL;
using Windows.UI.Xaml.Media.Imaging;
//using Windows.UI.Xaml.Window;
using Color = Windows.UI.Color;
using System.Numerics;


// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace Mandelbrot
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        ZbioryFraktalne zbiorFraktalny;
        private bool mandelbrotOrJulia = true;
        Rect _bounds;
        int height, width;
        byte[,] zbior = null;
        WriteableBitmap bufor; //Uwaga! To wymagało dodania do projektu referencji WriteableBitmapEx (przez NuGet)

        public MainPage()
        {
            this.InitializeComponent();

            _bounds = Window.Current.Bounds;
            width = (int)_bounds.Width;
            height = (int)_bounds.Height;
            zbiorFraktalny = new ZbioryFraktalne(width, height, ZbioryFraktalne.DefaultMin, ZbioryFraktalne.DefaultMax);
            //zbiorFraktalny.Szerokosc = width;
            //zbiorFraktalny.Wysokosc = height;
            bufor = new WriteableBitmap(width, height);
            ZapelnijBufor();
            obraz.Source = bufor;
        }

        private async void ZapelnijBufor()
        {
            //if (mandelbrotOrJulia) zbior = zbiorFraktalny.ZbiorMandelbrota;
            //else zbior = zbiorFraktalny.ZbiorJulii;

            progressRing.IsActive = true;

            zbior = await zbiorFraktalny.ObliczAsync(mandelbrotOrJulia);

            using (bufor.GetBitmapContext())
            {
                for (int x = 0; x < bufor.PixelWidth; x++)
                    for (int y = 0; y < bufor.PixelHeight; y++)
                    {
                        byte elementZbioru = Convert.ToByte(zbior[x, y]);
                        bufor.SetPixel(x, y, Color.FromArgb(255, elementZbioru, elementZbioru, elementZbioru));
                    }
            }

            progressRing.IsActive = false;
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {

        }

        private void Grid_Tapped(object sender, TappedRoutedEventArgs e)
        {            
            Point pozycja = e.GetPosition(this);
            Complex z = zbiorFraktalny.ClientToZespolone((int)pozycja.X, (int)pozycja.Y);
            Complex rozmiar = zbiorFraktalny.Rozmiar;
            rozmiar /= 3;
            zbiorFraktalny.Min = z - rozmiar / 2;
            zbiorFraktalny.Max = zbiorFraktalny.Min + rozmiar;
            ZapelnijBufor();
        }

        private void WyborZbioru_Click(object sender, RoutedEventArgs e)
        {
            pop.Visibility = Visibility.Visible;
            pop.HorizontalOffset = Window.Current.CoreWindow.Bounds.Left + 4;
            pop.VerticalOffset = Window.Current.CoreWindow.Bounds.Top + topAppBar.ActualHeight + 4;
            pop.IsOpen = true;
        }

        private void Przywroc_Click(object sender, RoutedEventArgs e)
        {
            zbiorFraktalny.Min = ZbioryFraktalne.DefaultMin;
            zbiorFraktalny.Max = ZbioryFraktalne.DefaultMax;
            ZapelnijBufor();
        }

        private void zbiorMandelbrota_Click(object sender, RoutedEventArgs e)
        {
            mandelbrotOrJulia = true;
            Przywroc_Click(null, null);
            pop.Visibility = Visibility.Collapsed;            
        }

        private void zbiorJulii_Click(object sender, RoutedEventArgs e)
        {
            mandelbrotOrJulia = false;
            Przywroc_Click(null, null);
            pop.Visibility = Visibility.Collapsed;            
        }
    }
}
