﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Numerics; //trzeba dodać bibliotekę do References
using MandelbrotPCL;

namespace MandelbrotEksplorator
{
    public partial class Form1 : Form
    {
        ZbioryFraktalne zbiorFraktalny;

        public Form1()
        {
            InitializeComponent();

            zbiorFraktalny = new ZbioryFraktalne(
                this.ClientSize.Width, this.ClientSize.Height,
                ZbioryFraktalne.DefaultMin, ZbioryFraktalne.DefaultMax);
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Text = "Czekaj...";
            Cursor = Cursors.WaitCursor;

            zbiorFraktalny.Szerokosc = ClientSize.Width;
            zbiorFraktalny.Wysokosc = ClientSize.Height;
            byte[,] zbior = null;
            
            if (zbiórMandelbrotaToolStripMenuItem.Checked) zbior = zbiorFraktalny.ZbiorMandelbrota;
            if (zbiórJuliiToolStripMenuItem.Checked) zbior = zbiorFraktalny.ZbiorJulii;            
            
            //Task<byte[,]> t = zbiorFraktalny.ObliczAsync(zbiórMandelbrotaToolStripMenuItem.Checked);
            //zbior = t.Result;

            //zbior = await zbiorFraktalny.ObliczAsync(zbiórMandelbrotaToolStripMenuItem.Checked);

            Bitmap bufor = new Bitmap(zbiorFraktalny.Szerokosc, zbiorFraktalny.Wysokosc);
            //to polepszyc!!!!!!
            for (int x = 0; x < bufor.Width; x++) //x,y - wspolrzedne pikseli
                for (int y = 0; y < bufor.Height; y++)
                {
                    int elementZbioru = zbior[x, y];
                    bufor.SetPixel(x, y, Color.FromArgb(elementZbioru, elementZbioru, elementZbioru));
                }

            Graphics g = e.Graphics;
            g.DrawImage(bufor, 0, 0);

            //osie
            int x0 = (int)(-zbiorFraktalny.Min.Real * ClientSize.Width / (zbiorFraktalny.Max.Real - zbiorFraktalny.Min.Real));
            int y0 = (int)(-zbiorFraktalny.Min.Imaginary * ClientSize.Height / (zbiorFraktalny.Max.Imaginary - zbiorFraktalny.Min.Imaginary));
            g.DrawLine(new Pen(Color.Gray, 1), new Point(x0, 0), new Point(x0, ClientSize.Height));
            g.DrawLine(new Pen(Color.Gray, 1), new Point(0, y0), new Point(ClientSize.Width, y0));

            if (zbiórMandelbrotaToolStripMenuItem.Checked) Text = "Zbiór Mandelbrota";
            if (zbiórJuliiToolStripMenuItem.Checked) Text = "Zbiór Julii";
            Text += " (zakres od " + zbiorFraktalny.Min.ToString() + " do " + zbiorFraktalny.Max.ToString() + ")";
            Cursor = Cursors.Arrow;
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            Refresh();
        }

        private void zbiórMandelbrotaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zbiórMandelbrotaToolStripMenuItem.Checked = (sender == zbiórMandelbrotaToolStripMenuItem);
            zbiórJuliiToolStripMenuItem.Checked = (sender == zbiórJuliiToolStripMenuItem);
            Refresh();
        }

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            Complex z = zbiorFraktalny.ClientToZespolone(e.X, e.Y);
            Complex rozmiar = zbiorFraktalny.Rozmiar;

            switch (e.Button)
            {
                case MouseButtons.Left:
                    rozmiar /= 3;
                    break;
                case MouseButtons.Right:
                    rozmiar *= 3;
                    break;
            }

            zbiorFraktalny.Min = z - rozmiar / 2;
            zbiorFraktalny.Max = zbiorFraktalny.Min + rozmiar;
            Refresh();
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            Complex z = zbiorFraktalny.ClientToZespolone(e.X, e.Y);
            toolStripStatusLabel1.Text = "Re: " + z.Real.ToString("G10") + "  Im: " + z.Imaginary.ToString("G10");
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            zbiorFraktalny.Min = ZbioryFraktalne.DefaultMin;
            zbiorFraktalny.Max = ZbioryFraktalne.DefaultMax;
            Refresh();
        }
    }
}
