using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace PierwszyProjekt
{

    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        BasicEffect effect;

        VertexBuffer buforWerteksow = null;
        float dx = 1f;
        float dy = 1f;
        float dz = 1f;
        

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }


        protected override void Initialize()
        {
            effect = new BasicEffect(graphics.GraphicsDevice);
            effect.VertexColorEnabled = true;

            effect.Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);
            effect.View = Matrix.CreateLookAt(new Vector3(0, 2, 3f), new Vector3(0, 0, 0), new Vector3(0, 1, 0));

            base.Initialize();
        }


        private void SetUpVertices()
        {
            Vector3[] punkty = new Vector3[8]{
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)};

            Color kolor1 = Color.Cyan;
            Color kolor2 = Color.Magenta;
            Color kolor3 = Color.Yellow;

            VertexPositionColor[] werteksy = new VertexPositionColor[6 * 4]{
                //przednia sciana
                new VertexPositionColor(punkty[3], kolor1),
                new VertexPositionColor(punkty[2], kolor1),
                new VertexPositionColor(punkty[0], kolor1),
                new VertexPositionColor(punkty[1], kolor1),

                //tylnia sciana
                new VertexPositionColor(punkty[7], kolor1),
                new VertexPositionColor(punkty[4], kolor1),
                new VertexPositionColor(punkty[6], kolor1),
                new VertexPositionColor(punkty[5], kolor1),
   
                //gorna sciana
                new VertexPositionColor(punkty[3], kolor2),
                new VertexPositionColor(punkty[7], kolor2),
                new VertexPositionColor(punkty[2], kolor2),
                new VertexPositionColor(punkty[6], kolor2),

                //dolna sciana
                new VertexPositionColor(punkty[0], kolor2),
                new VertexPositionColor(punkty[1], kolor2),
                new VertexPositionColor(punkty[4], kolor2),
                new VertexPositionColor(punkty[5], kolor2),
   
                //lewa sciana
                new VertexPositionColor(punkty[3], kolor3),
                new VertexPositionColor(punkty[0], kolor3),
                new VertexPositionColor(punkty[7], kolor3),
                new VertexPositionColor(punkty[4], kolor3),

                //prawa sciana
                new VertexPositionColor(punkty[1], kolor3),
                new VertexPositionColor(punkty[2], kolor3),
                new VertexPositionColor(punkty[5], kolor3),
                new VertexPositionColor(punkty[6], kolor3)};

            buforWerteksow = new VertexBuffer(GraphicsDevice, VertexPositionColor.VertexDeclaration, 
                                              werteksy.Count(), BufferUsage.WriteOnly);
            buforWerteksow.SetData<VertexPositionColor>(werteksy);
        }

        

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
            SetUpVertices();

        }

        protected override void UnloadContent()
        {
           
        }


        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            effect.World *= Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);

            base.Update(gameTime);
        }


        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            GraphicsDevice.SetVertexBuffer(buforWerteksow);

            foreach (EffectPass pass in effect.CurrentTechnique.Passes)
            {
                pass.Apply();

                for (int i = 0; i < 6; ++i)
                    GraphicsDevice.DrawPrimitives(PrimitiveType.TriangleStrip, 4 * i, 2);
            }
            base.Draw(gameTime);
        }
    }
}
