cbuffer ConstantBuffer : register(b)
{
	matrix world;
	matrix view;
	matrix projection;
};

struct VertexShaderInput
{
	float3 pos : POSITION;
	float3 color : COLOR;
};

struct VertexShaderOutput
{
	float4 pos : SV_POSITION;
	float3 color : COLOR;
};

VertexShaderOutput main(VertexShaderInput input)
{
	VertexShaderOutput output;
	float4 pos = float4(input.pos, 1.0f);
	pos = mul(pos,world);
	pos = mul(pos,view);
	pos = mul(pos,projection);
	output.pos = pos;
	output.color = input.color;
	return output;
}