#pragma once

using namespace Microsoft::WRL;
using namespace Windows::UI::Core;
using namespace DirectX;

using namespace Platform; //m.in. obsuga plikw w aplikacjach Windows Store, potrzebne do czytania plikw werteksw

#include "BasicMath.h"

struct Vertex
{
	//float x,y,z;
	float3 position;
	float3 color;
};

struct ConstantBuffer
{
	float4x4 world;
	float4x4 view;	
	float4x4 projection;
};

class CGame
{
private:
	ComPtr<ID3D11Device1> dev;
	ComPtr<ID3D11DeviceContext1> devcon;

	ComPtr<IDXGISwapChain1> swapchain;

	ComPtr<ID3D11RenderTargetView> renderTarget;

	//rysowanie trojkata
	ComPtr<ID3D11Buffer> vertexBuffer;
	ComPtr<ID3D11VertexShader> vertexShader;
	ComPtr<ID3D11PixelShader> pixelShader;
	ComPtr<ID3D11InputLayout> inputLayout;

	//rysowanie kostki
	ComPtr<ID3D11DepthStencilView> depthStencilView;
	ComPtr<ID3D11Buffer> indexBuffer; //ok poki nie ma normalnych
	ComPtr<ID3D11Buffer> constantBuffer;
	ConstantBuffer constantBufferData;
	float katObrotu;

public:
	void Initialize();
	void Update();
	void Render();

	//rysowanie trojkata
	void InitGraphics();
	void CGame::InitPipeline();
};