#include "pch.h"
#include "Game.h"

void CGame::Initialize()
{
	//tworzenie referencji do urzadzenia
	ComPtr<ID3D11Device> dev11;
	ComPtr<ID3D11DeviceContext> devcon11;

	D3D11CreateDevice(
		nullptr, //domylna karta graficzna, pierwszy z IDXAdapter::EnumAdapters
		D3D_DRIVER_TYPE::D3D_DRIVER_TYPE_HARDWARE,
		nullptr,
		0,
		nullptr,
		0,
		D3D11_SDK_VERSION,
		&dev11,
		nullptr,
		&devcon11
	);
	dev11.As(&dev);
	devcon11.As(&devcon);

	//swap chain
	ComPtr<IDXGIDevice1> dxgiDevice; dev.As(&dxgiDevice);
	ComPtr<IDXGIAdapter> dxgiAdapter; dxgiDevice->GetAdapter(&dxgiAdapter);
	ComPtr<IDXGIFactory2> dxgiFactory; dxgiAdapter->GetParent(__uuidof(IDXGIFactory2), &dxgiFactory);
	
	DXGI_SWAP_CHAIN_DESC1 scd={0};
	scd.BufferUsage=DXGI_USAGE_RENDER_TARGET_OUTPUT;
	scd.BufferCount=2; //ilo buforw
	scd.Format=DXGI_FORMAT_B8G8R8A8_UNORM;
	scd.SwapEffect=DXGI_SWAP_EFFECT_FLIP_SEQUENTIAL;
	scd.SampleDesc.Count=1; //antyaliasing

	CoreWindow^ Window = CoreWindow::GetForCurrentThread();
	
	dxgiFactory->CreateSwapChainForCoreWindow(
		dev.Get(),
		reinterpret_cast<IUnknown*>(Window),
		&scd,
		nullptr,
		&swapchain
	);

	//ustawianie celu renderowania
	ComPtr<ID3D11Texture2D> backBuffer;
	swapchain->GetBuffer(0,__uuidof(ID3D11Texture2D), &backBuffer);	
	dev->CreateRenderTargetView(backBuffer.Get(), nullptr, &renderTarget);

	//----------------------------------do rysowania trojkata

	//ustawianie viewportu
	D3D11_VIEWPORT viewport = {0};
	viewport.TopLeftX=0;
	viewport.TopLeftY=0;
	viewport.Width=Window->Bounds.Width;
	viewport.Height=Window->Bounds.Height;
	devcon->RSSetViewports(1,&viewport);

	//----------------------------------do rysowania kostki

	//tworzenie bufora depth-stencil
	ComPtr<ID3D11Texture2D> depthStencil;
	dev->CreateTexture2D(nullptr, nullptr, &depthStencil);
	D3D11_DEPTH_STENCIL_VIEW_DESC depthStencilViewDescription;
	depthStencilViewDescription.ViewDimension=D3D11_DSV_DIMENSION_TEXTURE2D;
	depthStencilViewDescription.Flags = 0;
	depthStencilViewDescription.Texture2D.MipSlice = 0;
	dev->CreateDepthStencilView(depthStencil.Get(), & depthStencilViewDescription, &depthStencilView);

	//skalowanie
	D3D11_TEXTURE2D_DESC backBufferDesc = {0};
	backBuffer->GetDesc(&backBufferDesc);	
	float hS = 2;
	float wS = hS * backBufferDesc.Height / backBufferDesc.Width;

	/*
	const float zn=1.0f; //bliz (z near)
	const float zf=2.0f; //dal (z far)
	const float a = zf/(zn-zf);
	const float b = zn*zf/(zn-zf);

	constantBufferData.projection = float4x4(
        wS,		0.0f,    0.0f,  0.0f,
        0.0f,   hS,		 0.0f,  0.0f,
        0.0f,   0.0f,   a, b,
        0.0f,   0.0f,	b,  0.0f
    );
	*/

	constantBufferData.projection = float4x4(
        wS,		0.0f,    0.0f,  0.0f,
        0.0f,   hS,		 0.0f,  0.0f,
        0.0f,   0.0f,   -2.0f, -1.0f,
        0.0f,   0.0f,	-1.0f,  0.0f
    );

	constantBufferData.world = identity();

	InitGraphics();
	InitPipeline();
}

void CGame::Update()
{	
}

//---------------------------------------------------------do rysowanie kostki
short indicies[] =
{
	//przod
	0, 1, 2,
	0, 2, 3,

	//tyl
	4, 5, 6,
	4, 6, 7,

	//lewa
	3, 2, 5,
	3, 5, 4,

	//prawa
	2, 1, 6,
	2, 6, 5,

	//gora	
	1, 0, 7,
	1, 7, 6,	

	//dol
	0, 3, 4,
	0, 4, 7
};


void CGame::Render()
{
	//---------------------------------------------------------do rysowania kostki
	//constantBufferData.world = rotationY(2.0f);
	//katObrotu += 2.0f;
	constantBufferData.world=mul(constantBufferData.world,rotationY(2.0f));

	devcon->UpdateSubresource(constantBuffer.Get(),0,nullptr,&constantBufferData,0,0);

	//---------------------------------------------------------pierwotne

	devcon->OMSetRenderTargets(1, renderTarget.GetAddressOf(), nullptr);

	float colorTla[4]={0.0f,0.0f,0.0f,1.0f};
	devcon->ClearRenderTargetView(renderTarget.Get(),colorTla);

	//---------------------------------------------------------do rysowania trojkata

	UINT stride = sizeof(Vertex);
	UINT offset = 0;
	devcon->IASetVertexBuffers(0,1,vertexBuffer.GetAddressOf(),&stride,&offset);
	devcon->IASetIndexBuffer(indexBuffer.Get(), DXGI_FORMAT_R16_UINT, 0); //dodane przy rysowaniu kostki
	devcon->IASetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST); //ustalanie primitywu
	//devcon->Draw(3,0);
	devcon->DrawIndexed(ARRAYSIZE(indicies) ,0, 0); //zmiana przy rysowaniu kostki

	//--------------------------------------------------------

	swapchain->Present(1,0);
}

//------------------------------------------------------------------------do rysowania trojkata

//inicjowanie grafiki
void CGame::InitGraphics()
{
	/*
	Vertex verticies[]=
	{
		{0.0f,0.5f,0.0f},
		{0.45f,-0.5f,0.0f},
		{-0.45f,-0.5f,0.0f}
	};
	*/
	Vertex verticies[]=
	{
		{ float3(-0.5f, 0.5f, -0.5f), float3(0.0f, 1.0f, 0.0f) },
		{ float3( 0.5f, 0.5f, -0.5f), float3(1.0f, 1.0f, 0.0f) },
		{ float3( 0.5f, 0.5f,  0.5f), float3(1.0f, 1.0f, 1.0f) },
		{ float3(-0.5f, 0.5f,  0.5f), float3(0.0f, 1.0f, 1.0f) },

		{ float3(-0.5f, -0.5f,  0.5f), float3(0.0f, 0.0f, 1.0f) },
		{ float3( 0.5f, -0.5f,  0.5f), float3(1.0f, 0.0f, 1.0f) },
		{ float3( 0.5f, -0.5f, -0.5f), float3(1.0f, 0.0f, 0.0f) },
		{ float3(-0.5f, -0.5f, -0.5f), float3(0.0f, 0.0f, 0.0f) },
	};

	D3D11_BUFFER_DESC opisBufora = {0}; //opis bufora werteksow
	opisBufora.ByteWidth = sizeof(Vertex)*ARRAYSIZE(verticies);
	opisBufora.BindFlags = D3D11_BIND_VERTEX_BUFFER;
	D3D11_SUBRESOURCE_DATA dane = {verticies, 0,0};
	dev->CreateBuffer(&opisBufora,&dane,&vertexBuffer);

	//------------------------------------------------do rysowania kostki
	D3D11_BUFFER_DESC opisBuforaIndeksow={0};
	opisBuforaIndeksow.ByteWidth=sizeof(unsigned short) * ARRAYSIZE(indicies);
	opisBuforaIndeksow.BindFlags = D3D11_BIND_INDEX_BUFFER;

	D3D11_SUBRESOURCE_DATA daneZrodlaBuforaIndeksow = {indicies, 0, 0};
	dev->CreateBuffer(&opisBuforaIndeksow,&daneZrodlaBuforaIndeksow, &indexBuffer);

	//bufor do przeslania macierzy swiata, widoku i rzutowania
	D3D11_BUFFER_DESC constantBufferDesc = {0};
	constantBufferDesc.ByteWidth = sizeof(constantBufferData);
	constantBufferDesc.BindFlags = D3D11_BIND_CONSTANT_BUFFER;
	dev->CreateBuffer(&constantBufferDesc,nullptr,&constantBuffer);

	constantBufferData.view = float4x4(
	   -1.0f, 0.0f,  0.0f,  0.0f,
        0.0f, 1.0f,  0.5f,  0.0f,
        0.0f, 0.5f, -1.0f, -3.0f,
        0.0f, 0.0f,  0.0f,  4.0f
    );
}

//funkcja pomocnicza czytanie skompilowanych shaderow
#include <fstream>
Array<byte>^ LoadShaderFile(std::string nazwaPliku)
{
	Array<byte>^ daneZPliku = nullptr;
	std::ifstream vertexFile(nazwaPliku,std::ios::in | std::ios::binary | std::ios::ate);
	if(vertexFile.is_open())
	{
		int wielkoscPliku = (int)vertexFile.tellg();
		daneZPliku=ref new Array<byte>(wielkoscPliku);
		vertexFile.seekg(0,std::ios::beg);
		vertexFile.read(reinterpret_cast<char*>(daneZPliku->Data),wielkoscPliku);
		vertexFile.close();
	}
	return daneZPliku;
}

void CGame::InitPipeline() //pipline = potok
{
	Array<byte>^ plikVS=LoadShaderFile("VertexShader.cso"); //CSO = compiled shader object
	Array<byte>^ plikPS=LoadShaderFile("PixelShader.cso");

	dev->CreateVertexShader(plikVS->Data, plikVS->Length, nullptr, &vertexShader);
	dev->CreatePixelShader(plikPS->Data, plikPS->Length, nullptr, &pixelShader);

	devcon->VSSetShader(vertexShader.Get(),nullptr,0);
	devcon->PSSetShader(pixelShader.Get(),nullptr,0);
	devcon->VSSetConstantBuffers(0,1,constantBuffer.GetAddressOf());

	D3D11_INPUT_ELEMENT_DESC opisElementowWerteksu[] =
	{
		{"POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT,0,0,D3D11_INPUT_PER_VERTEX_DATA,0},
		{"COLOR", 0, DXGI_FORMAT_R32G32B32_FLOAT,0,12,D3D11_INPUT_PER_VERTEX_DATA,0}
	};

	dev->CreateInputLayout(opisElementowWerteksu, ARRAYSIZE(opisElementowWerteksu), plikVS->Data, plikVS->Length, &inputLayout);
	devcon->IASetInputLayout(inputLayout.Get());
}
