#include "pch.h"
#include "Game.h"

void CGame::Initialize()
{
	//tworzenie referencji do urzadzenia
	ComPtr<ID3D11Device> dev11;
	ComPtr<ID3D11DeviceContext> devcon11;

	D3D11CreateDevice(
		nullptr, //domylna karta graficzna, pierwszy z IDXAdapter::EnumAdapters
		D3D_DRIVER_TYPE::D3D_DRIVER_TYPE_HARDWARE,
		nullptr,
		0,
		nullptr,
		0,
		D3D11_SDK_VERSION,
		&dev11,
		nullptr,
		&devcon11
	);
	dev11.As(&dev);
	devcon11.As(&devcon);

	//swap chain
	ComPtr<IDXGIDevice1> dxgiDevice; dev.As(&dxgiDevice);
	ComPtr<IDXGIAdapter> dxgiAdapter; dxgiDevice->GetAdapter(&dxgiAdapter);
	ComPtr<IDXGIFactory2> dxgiFactory; dxgiAdapter->GetParent(__uuidof(IDXGIFactory2), &dxgiFactory);
	
	DXGI_SWAP_CHAIN_DESC1 scd={0};
	scd.BufferUsage=DXGI_USAGE_RENDER_TARGET_OUTPUT;
	scd.BufferCount=2; //ilo buforw
	scd.Format=DXGI_FORMAT_B8G8R8A8_UNORM;
	scd.SwapEffect=DXGI_SWAP_EFFECT_FLIP_SEQUENTIAL;
	scd.SampleDesc.Count=1; //antyaliasing

	CoreWindow^ Window = CoreWindow::GetForCurrentThread();
	
	dxgiFactory->CreateSwapChainForCoreWindow(
		dev.Get(),
		reinterpret_cast<IUnknown*>(Window),
		&scd,
		nullptr,
		&swapchain
	);

	//ustawianie celu renderowania
	ComPtr<ID3D11Texture2D> backBuffer;
	swapchain->GetBuffer(0,__uuidof(ID3D11Texture2D), &backBuffer);	
	dev->CreateRenderTargetView(backBuffer.Get(), nullptr, &renderTarget);

	//---------------------------------

	//ustawianie viewportu
	D3D11_VIEWPORT viewport = {0};
	viewport.TopLeftX=0;
	viewport.TopLeftY=0;
	viewport.Width=Window->Bounds.Width;
	viewport.Height=Window->Bounds.Height;
	devcon->RSSetViewports(1,&viewport);

	InitGraphics();
	InitPipeline();
}

void CGame::Update()
{
}

void CGame::Render()
{
	devcon->OMSetRenderTargets(1, renderTarget.GetAddressOf(), nullptr);

	float colorTla[4]={0.0f,0.2f,0.4f,1.0f};
	devcon->ClearRenderTargetView(renderTarget.Get(),colorTla);

	//--------------------------------------------------------

	UINT stride = sizeof(Vertex);
	UINT offset = 0;
	devcon->IASetVertexBuffers(0,1,vertexBuffer.GetAddressOf(),&stride,&offset);
	devcon->IASetPrimitiveTopology(D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST); //ustalanie primitywu
	devcon->Draw(3,0);

	//--------------------------------------------------------

	swapchain->Present(1,0);
}

//-------------------------------------------------------------------------

//inicjowanie grafiki
void CGame::InitGraphics()
{
	Vertex verticies[]=
	{
		{0.0f,0.5f,0.0f},
		{0.45f,-0.5f,0.0f},
		{-0.45f,-0.5f,0.0f}
	};

	D3D11_BUFFER_DESC opisBufora = {0};
	opisBufora.ByteWidth = sizeof(Vertex)*ARRAYSIZE(verticies);
	opisBufora.BindFlags = D3D11_BIND_VERTEX_BUFFER;
	D3D11_SUBRESOURCE_DATA dane = {verticies, 0,0};
	dev->CreateBuffer(&opisBufora,&dane,&vertexBuffer);
}

//funkcja pomocnicza czytanie skompilowanych shaderow
#include <fstream>
Array<byte>^ LoadShaderFile(std::string nazwaPliku)
{
	Array<byte>^ daneZPliku = nullptr;
	std::ifstream vertexFile(nazwaPliku,std::ios::in | std::ios::binary | std::ios::ate);
	if(vertexFile.is_open())
	{
		int wielkoscPliku = (int)vertexFile.tellg();
		daneZPliku=ref new Array<byte>(wielkoscPliku);
		vertexFile.seekg(0,std::ios::beg);
		vertexFile.read(reinterpret_cast<char*>(daneZPliku->Data),wielkoscPliku);
		vertexFile.close();
	}
	return daneZPliku;
}

void CGame::InitPipeline() //pipline = potok
{
	Array<byte>^ plikVS=LoadShaderFile("VertexShader.cso"); //CSO = compiled shader object
	Array<byte>^ plikPS=LoadShaderFile("PixelShader.cso");

	dev->CreateVertexShader(plikVS->Data, plikVS->Length, nullptr, &vertexShader);
	dev->CreatePixelShader(plikPS->Data, plikPS->Length, nullptr, &pixelShader);

	devcon->VSSetShader(vertexShader.Get(),nullptr,0);
	devcon->PSSetShader(pixelShader.Get(),nullptr,0);

	D3D11_INPUT_ELEMENT_DESC opisElementowWerteksu[] =
	{
		{"POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT,0,0,D3D11_INPUT_PER_VERTEX_DATA,0}
	};

	dev->CreateInputLayout(opisElementowWerteksu, ARRAYSIZE(opisElementowWerteksu), plikVS->Data, plikVS->Length, &inputLayout);
	devcon->IASetInputLayout(inputLayout.Get());
}