#include "pch.h"
#include "Game.h"

void CGame::Initialize()
{
	//tworzenie referencji do urzadzenia
	ComPtr<ID3D11Device> dev11;
	ComPtr<ID3D11DeviceContext> devcon11;

	D3D11CreateDevice(
		nullptr, //domylna karta graficzna, pierwszy z IDXAdapter::EnumAdapters
		D3D_DRIVER_TYPE::D3D_DRIVER_TYPE_HARDWARE,
		nullptr,
		0,
		nullptr,
		0,
		D3D11_SDK_VERSION,
		&dev11,
		nullptr,
		&devcon11
	);
	dev11.As(&dev);
	devcon11.As(&devcon);

	//swap chain
	ComPtr<IDXGIDevice1> dxgiDevice; dev.As(&dxgiDevice);
	ComPtr<IDXGIAdapter> dxgiAdapter; dxgiDevice->GetAdapter(&dxgiAdapter);
	ComPtr<IDXGIFactory2> dxgiFactory; dxgiAdapter->GetParent(__uuidof(IDXGIFactory2), &dxgiFactory);
	
	DXGI_SWAP_CHAIN_DESC1 scd={0};
	scd.BufferUsage=DXGI_USAGE_RENDER_TARGET_OUTPUT;
	scd.BufferCount=2; //ilo buforw
	scd.Format=DXGI_FORMAT_B8G8R8A8_UNORM;
	scd.SwapEffect=DXGI_SWAP_EFFECT_FLIP_SEQUENTIAL;
	scd.SampleDesc.Count=1; //antyaliasing

	CoreWindow^ Window = CoreWindow::GetForCurrentThread();
	
	dxgiFactory->CreateSwapChainForCoreWindow(
		dev.Get(),
		reinterpret_cast<IUnknown*>(Window),
		&scd,
		nullptr,
		&swapchain
	);

	//ustawianie celu renderowania
	ComPtr<ID3D11Texture2D> backBuffer;
	swapchain->GetBuffer(0,__uuidof(ID3D11Texture2D), &backBuffer);	
	dev->CreateRenderTargetView(backBuffer.Get(), nullptr, &renderTarget);
}

void CGame::Update()
{
}

void CGame::Render()
{
	devcon->OMSetRenderTargets(1, renderTarget.GetAddressOf(), nullptr);

	float colorTla[4]={0.0f,0.2f,0.4f,1.0f};
	devcon->ClearRenderTargetView(renderTarget.Get(),colorTla);

	swapchain->Present(1,0);
}