﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;


using System.Text;
using Windows.Storage;
using Windows.UI.Popups;
using VK = Windows.System.VirtualKey;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace MenedżerDokumentów
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
            
            LewyComboBox.ItemsSource = GetFoldersNames();
            PrawyComboBox.ItemsSource = GetFoldersNames();
            LewyComboBox.SelectedIndex = 0;
            PrawyComboBox.SelectedIndex = 1;

            //OdświeżLewyPanel();
            //OdświeżPrawyPanel();
        }

        private static List<StorageFolder> GetFolders()
        {
            List<StorageFolder> foldery = new List<StorageFolder>();
            //foldery.Add(KnownFolders.DocumentsLibrary); //uprawnienia!
            foldery.Add(KnownFolders.PicturesLibrary);
            foldery.Add(KnownFolders.MusicLibrary);
            foldery.Add(KnownFolders.VideosLibrary);
            return foldery;
        }

        private static List<string> GetFoldersNames()
        {
            List<StorageFolder> foldery = GetFolders();
            List<string> nazwyFolderow = new List<string>(foldery.Count);
            foreach (StorageFolder folder in foldery)
            {
                nazwyFolderow.Add(folder.Name);
            }
            return nazwyFolderow;
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
        }

        private async void OdświeżPanel(ListView panel, ComboBox cb)        
        {            
            List<StorageFolder> foldery = GetFolders();
            StorageFolder folder = foldery[cb.SelectedIndex];
            panel.Items.Clear();

            IReadOnlyList<IStorageItem> elementy = await folder.GetItemsAsync();

            foreach (var element in elementy)
            {
                if (element is StorageFolder)
                {
                    panel.Items.Add("[ " + element.Name + " ]");
                }
                else
                {
                    panel.Items.Add(element.Name);
                }
            }
        }

        private void OdświeżLewyPanel()
        {
            OdświeżPanel(LewyPanel, LewyComboBox);
        }

        private void OdświeżPrawyPanel()
        {
            OdświeżPanel(PrawyPanel, PrawyComboBox);
        }

        private async void UtworzPlikLubKatalog(bool utworzKatalog = false)
        {
            List<StorageFolder> foldery = GetFolders();
            StorageFolder folderLewy = foldery[LewyComboBox.SelectedIndex];
            StorageFolder folderPrawy = foldery[PrawyComboBox.SelectedIndex];            

            string lewyNazwa = LewyNazwa.Text;
            string prawyNazwa = PrawyNazwa.Text;
            if (lewyNazwa != "")
            {
                if (utworzKatalog) await folderLewy.CreateFolderAsync(lewyNazwa);
                else await folderLewy.CreateFileAsync(lewyNazwa);
                LewyNazwa.Text = "";
                OdświeżLewyPanel();
            }
            if (prawyNazwa != "")
            {
                if (utworzKatalog) await folderPrawy.CreateFolderAsync(prawyNazwa);
                else await folderPrawy.CreateFileAsync(prawyNazwa);
                PrawyNazwa.Text = "";
                OdświeżPrawyPanel();
            }
        }

        private void Utwórz_Click(object sender, RoutedEventArgs e)
        {
            UtworzPlikLubKatalog();
        }

        private async void KopiujPlik(bool usunKopiowanyPlik = false)
        {
            //kopiuje z lewego do prawego
            StorageFolder folderLewy = GetFolders()[LewyComboBox.SelectedIndex];
            StorageFolder folderPrawy = GetFolders()[PrawyComboBox.SelectedIndex];

            if (folderLewy.Path == folderPrawy.Path)
            {
                await new MessageDialog("Foldery w obu panelach muszą się różnić").ShowAsync();
                return;
            }

            IReadOnlyList<StorageFolder> folderyLewy = await folderLewy.GetFoldersAsync();
            IReadOnlyList<StorageFile> plikiLewy = await folderLewy.GetFilesAsync();
            StorageFile kopiowanyPlik = plikiLewy[LewyPanel.SelectedIndex - folderyLewy.Count];
            if(usunKopiowanyPlik) 
            {                
                await kopiowanyPlik.MoveAsync(folderPrawy);
                OdświeżLewyPanel();
            }
            else await kopiowanyPlik.CopyAsync(folderPrawy);
            OdświeżPrawyPanel();
        }

        private async void Kopiuj_Click(object sender, RoutedEventArgs e)
        {
            KopiujPlik();            
        }

        private void Przenieś_Click(object sender, RoutedEventArgs e)
        {
            KopiujPlik(true);
        }

        private void NowyFolder_Click(object sender, RoutedEventArgs e)
        {
            UtworzPlikLubKatalog(true);
        }

        private async void Usuń_Click(object sender, RoutedEventArgs e)
        {
            //usuwa z lewego
            StorageFolder folderLewy = GetFolders()[LewyComboBox.SelectedIndex];            
            IReadOnlyList<StorageFolder> folderyLewy = await folderLewy.GetFoldersAsync();
            IReadOnlyList<StorageFile> plikiLewy = await folderLewy.GetFilesAsync();
            StorageFile usuwanyPlik = plikiLewy[LewyPanel.SelectedIndex - folderyLewy.Count];
            await usuwanyPlik.DeleteAsync();
            OdświeżLewyPanel();
        }

        private void LewyComboBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            OdświeżLewyPanel();
        }

        private void PrawyComboBox_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            OdświeżPrawyPanel();
        }

        private void Grid_KeyDown_1(object sender, KeyRoutedEventArgs e)
        {
            switch (e.Key)
            {
                case VK.F4: Utwórz_Click(null, null); break;
                case VK.F5: Kopiuj_Click(null, null); break;
                case VK.F6: Przenieś_Click(null, null); break;
                case VK.F7: NowyFolder_Click(null, null); break;
                case VK.F8: Usuń_Click(null, null); break;
            }
        }
    }
}
