﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Xrm;
using Microsoft.Xrm.Client;
using System.Drawing;
using System.Data.Linq.SqlClient;

namespace ToolsCRM.user_sites
{
    public partial class Agenda : System.Web.UI.Page
    {
        public List<DateTime> lista;

        protected void Page_Load(object sender, EventArgs e)
        {
            //appointment
           

            var xrm = new XrmServiceContext("Xrm");

            var agenda = from k in xrm.AppointmentSet
                         select new{
                             Temat = k.Subject,
                             Rodzaj = k.ActivityTypeCode,
                             Start = k.ScheduledStart,
                             End = k.ScheduledEnd
                         };           
            
            GridView2.DataSource = agenda;
            GridView2.DataBind();

            lista = new List<DateTime>();
            foreach (var a in agenda)
            {
                lista.Add(a.Start.Value);
            }

            if (Session["user"] == null)
                Response.Redirect("../error.aspx");
            else
            {
                Label1.Text = Session["user"].ToString();

            }
        }

        protected void Wyloguj_Click(object sender, EventArgs e)
        {
            Session["admin"] = null;
            Session["user"] = null;
            Response.Redirect("../Index.aspx");
        }

        protected void Calendar1_DayRender(object sender, DayRenderEventArgs e)
        {
            for (int i = 0; i < lista.Count; i++)
            {
                if ((lista[i].ToString() != DBNull.Value.ToString()))
                {
                    DateTime data = lista[i];
                    //Label2.Text = lista[i].ToString() + " " + data.ToString();

                    if (e.Day.Date.Month == data.Month)
                    {

                        if (e.Day.Date.Day == data.Day)
                        {

                            //e.Cell.ForeColor = Color.Azure;

                            e.Cell.BackColor = System.Drawing.ColorTranslator.FromHtml("#329EC2");

                            e.Cell.Font.Bold = true;

                        }

                    }
                    
                    /*
                    if (data == Calendar1.TodaysDate.Date)
                    {
                        //e.Cell.BackColor = Color.Red;
                        e.Cell.BackColor = System.Drawing.ColorTranslator.FromHtml("#b000");
                        Calendar1.DayStyle.BackColor = Color.Red;
                    }*/
                }
            }
            
        }

        protected void Calendar1_SelectionChanged(object sender, EventArgs e)
        {
            var xrm = new XrmServiceContext("Xrm");
            Label2.Text = "";
            foreach (DateTime dt in Calendar1.SelectedDates)
            {
                string data = dt.ToShortDateString().Split(' ').First();
                /*var dzien = (from k in xrm.AppointmentSet
                             where SqlMethods.Like(k.ScheduledStart.ToString(),data+"%")
                             
                             //SqlMethods.Like(k.ScheduledStart.ToString(), dt.ToShortDateString().Split(' ').First() + "%")
                            
                            select new
                            {
                                Temat = k.Subject
                            }).Single();*/

                var zdarzenie = xrm.AppointmentSet.ToList().FindAll(z => z.ScheduledStart.ToString().StartsWith(data)).ToList();
                for (int i = 0; i < zdarzenie.Count; i++)
                    Label2.Text += zdarzenie[i].ScheduledStart.ToString().Split(' ').Last() + " .......... \"" + zdarzenie[i].Subject + "\""+"<br/>";
                    //Convert.ToDateTime(dt.ToShortDateString()).ToString();
                

                //count++;

                 //date_str = date_str + "Selected Date #" + ": " +

                   // dt.ToShortDateString() + "<br/>"+ dzien.Temat;

            }



          
        }
    }
}