﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Xrm;
using Microsoft.Xrm.Client;

namespace ToolsCRM.user_sites
{
    public partial class Account : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            var xrm = new XrmServiceContext("Xrm");

            var account = (from c in xrm.ContactSet
                           join a in xrm.AccountSet
                           on c.ContactId equals a.PrimaryContactId.Id
                           select new
                           {
                                    NazwaKonta = a.Name,
                                    Telefon = a.Telephone1,
                                    Miasto = a.Address1_City,        
                                    Imie = c.FirstName,
                                    Nazwisko = c.LastName,
                                    email = c.EMailAddress1
                           });

            GridView2.DataSource = account;
            GridView2.DataBind();



            if (Session["user"] == null)
                Response.Redirect("../error.aspx");
            else
            {
                Label1.Text = Session["user"].ToString();

            }
        }

        protected void Wyloguj_Click(object sender, EventArgs e)
        {
            Session["admin"] = null;
            Session["user"] = null;
            Response.Redirect("../Index.aspx");
        }
    }
}