﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace KatalogFilmow
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private string nazwaPliku = "";
        List<Film> filmy = new List<Film>();

        public MainWindow()
        {
            InitializeComponent();
        }

        private void wybierzObraz(object sender, RoutedEventArgs e)
        {
            nazwaPliku = "";
            Microsoft.Win32.OpenFileDialog ofd = new Microsoft.Win32.OpenFileDialog();
            ofd.Filter = "Obrazy|*.jpg;*.jpe;*.jpeg;*.bmp;*.png|Wszystkie pliki|*.*";
            bool? wynik = ofd.ShowDialog();
            if (wynik == true)
            {
                nazwaPliku = ofd.FileName;
            }            
        }

        private void dodaj(object sender, RoutedEventArgs e)
        {
            if (dodajRezyser.Text == "" || dodajRok.Text == "" || dodajTytul.Text == "" || nazwaPliku == "")
            {
                komunikat.Content = "Nie można dodać filmu";
            }
            else
            {
                komunikat.Content = "";
                Film nowyFilm=new Film(dodajTytul.Text, dodajRezyser.Text, dodajRok.Text, nazwaPliku);
                filmy.Add(nowyFilm);
                dodajTytul.Text = dodajRezyser.Text = dodajRok.Text = nazwaPliku = "";
                listView1.Items.Add(nowyFilm.Opis);
            }
        }

        private void wyswietlInformacje(object sender, SelectionChangedEventArgs e)
        {
            Film wybranyFilm=filmy[listView1.SelectedIndex];
            wyswietlTytul.Text = wybranyFilm.Tytul;
            wyswietlRok.Text = wybranyFilm.Rok;
            wyswietlRezyser.Text = wybranyFilm.Rezyser;
            wyswietlObraz.Source = wybranyFilm.Obraz;
        }
    }
}
