﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace DragAndDrop
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Window1 : Window
    {
        ListBoxItem przenoszonyElement = null;
        ListBox listaZrodlo = null;

        public Window1()
        {
            InitializeComponent();
        }

        private void listBox1_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            if (przenoszonyElement != null) return;
            ListBox lbSender = sender as ListBox;
            UIElement element = lbSender.InputHitTest(e.GetPosition(lbSender)) as UIElement;
            while (element != null)
            {
                if (element is ListBoxItem)
                {
                    przenoszonyElement = element as ListBoxItem;
                    listaZrodlo = lbSender;
                    break;
                }
                //idzie do góry aż dojdzie do poziomu ListBoxItem (element może być złożony z kontrolek)
                element = VisualTreeHelper.GetParent(element) as UIElement; 
            }            
        }

        private void Window_MouseMove(object sender, MouseEventArgs e)
        {
            if (przenoszonyElement == null) return;
            if (e.LeftButton == MouseButtonState.Released)
            {
                przenoszonyElement = null;
                return;
            }
            DataObject obj = new DataObject(DataFormats.Text, przenoszonyElement.ToString());
            DragDrop.DoDragDrop(przenoszonyElement, obj, DragDropEffects.All);
        }

        private void listBox2_DragEnter(object sender, DragEventArgs e)
        {
            if (przenoszonyElement == null || !e.Data.GetDataPresent(DataFormats.Text, true))
            {
                e.Effects = DragDropEffects.None;
            }
            else
            {
                e.Effects = DragDropEffects.All;
            }
        }

        private void listBox2_Drop(object sender, DragEventArgs e)
        {
            listaZrodlo.Items.Remove(przenoszonyElement);

            //(sender as ListBox).Items.Add(przenoszonyElement);
            ListBox lbSender = sender as ListBox;
            UIElement element = lbSender.InputHitTest(e.GetPosition(lbSender)) as UIElement;
            while (element != null)
            {
                if (element is ListBoxItem) //mysz byla nad ListBoxItem lub jego skladnikiem
                {
                    int indeks = lbSender.Items.IndexOf(element);
                    if (indeks > 0) lbSender.Items.Insert(indeks, przenoszonyElement);
                    else lbSender.Items.Add(przenoszonyElement);
                    break;
                }
                if (element is ListBox) //mysz nie jest nad ListBoxItem lub jego pod-elementem
                {
                    lbSender.Items.Add(przenoszonyElement);
                }
                //idzie do góry aż dojdzie do poziomu ListBoxItem (element może być złożony z kontrolek)
                element = VisualTreeHelper.GetParent(element) as UIElement;
            }
        }
    }
}
