﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace DragAndDrop
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Point polozenieObrazu;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void obraz_MouseDown(object sender, MouseButtonEventArgs e)
        {
            obraz.CaptureMouse();
            polozenieObrazu = e.GetPosition(płótno);
        }

        private void obraz_MouseUp(object sender, MouseButtonEventArgs e)
        {
            obraz.ReleaseMouseCapture();
        }

        private void obraz_MouseMove(object sender, MouseEventArgs e)
        {
            Point p = e.GetPosition(płótno);
            if (e.LeftButton == MouseButtonState.Pressed)
            {
                Canvas.SetLeft(obraz, Canvas.GetLeft(obraz) + (p.X - polozenieObrazu.X));
                Canvas.SetTop(obraz, Canvas.GetTop(obraz) + (p.Y - polozenieObrazu.Y));
            }
            polozenieObrazu = p;
        }

        private void obraz_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            double współczynnik = 50;
            double nowaSzerokosc = obraz.Width + e.Delta/współczynnik;
            double nowaWysokosc = obraz.Height + e.Delta/współczynnik;
            if (nowaSzerokosc > 0 & nowaWysokosc > 0)
            {
                obraz.Width = nowaSzerokosc;
                obraz.Height = nowaWysokosc;
            }
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            new Window1().Show();
        }
    }
}
