namespace Sample.Mvvm.App.Sl.Repositories
{
    using System;
    using System.Collections.Generic;
    using Sample.Mvvm.App.Sl.Model;
    using System.Linq;

    public class FakeUserRepository : IUserRepository
    {
        private List<User> fakeData = new List<User>
                                          {
                                              new User()
                                                  {
                                                      Id = 1,
                                                      FirstName = "Adam",
                                                      LastName = "Kowalski",
                                                      Email = "adas.kowalski@gmail.com",
                                                      DateOfBirth = new DateTime(1980, 1, 1)
                                                  },
                                              new User()
                                                  {
                                                      Id = 2,
                                                      FirstName = "Jan",
                                                      MiddleName = "Pawe",
                                                      LastName = "Winiewski",
                                                      Email = "jan,wisniewski@gmail.com",
                                                      DateOfBirth = new DateTime(1990, 2, 3)
                                                  }
                                          };

        private int GetNextId()
        {
            var ids = this.fakeData.Select(x => x.Id);
            return ids.Last().Value + 1;
        }

        public IList<User> GetAll()
        {
            this.fakeData.Sort((u1, u2) => u1.Id.Value.CompareTo(u2.Id.Value));
            return this.fakeData.ToList();
        }

        public void Save(User user)
        {
            if (user.Id == null)
            {
                user.Id = this.GetNextId();
                this.fakeData.Add(user);
            }
            else
            {
                var existingUser = this.fakeData.Where(x => x.Id.Equals(user.Id)).First();
                this.fakeData.Remove(existingUser);
                this.fakeData.Add(user);
            }
        }

        public void Delete(User user)
        {
            if (user != null && user.Id != null)
            {
                var existingUser = this.fakeData.Where(x => x.Id.Equals(user.Id)).First();
                this.fakeData.Remove(existingUser);
            }
        }
    }
}