namespace Sample.Mvvm.App.Sl.Commands
{
    using System;
    using System.Windows.Input;

    public class RelayCommand : ICommand
    {
        public event EventHandler CanExecuteChanged;

        private readonly Predicate<object> canExecute;
        private readonly Action<object> executeAction;

        public RelayCommand(Action<object> executeAction)
        {
            this.canExecute = x => true;
            this.executeAction = executeAction;
        }

        public RelayCommand(Action<object> executeAction, Predicate<object> canExecute)
        {
            this.canExecute = canExecute;
            this.executeAction = executeAction;
        }


        public bool CanExecute(object parameter)
        {
            return this.canExecute == null || this.canExecute(parameter);
        }

        public void UpdateCanExecuteState()
        {
            if (CanExecuteChanged != null)
            {
                CanExecuteChanged(this, new EventArgs());
            }
        }
        public void Execute(object parameter)
        {
            if (this.executeAction != null)
            {
                this.executeAction(parameter);
            }   
            this.UpdateCanExecuteState();
        }
    }
}