﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Web.Mvc;
using Ninject;
using Produkty.Models.Abstract;
using test.Models.Concrete;

namespace Produkty.Infrastructure
{
    public class NinjectFactory : DefaultControllerFactory
    {
        private IKernel ninjectKernel;

        public NinjectFactory()
        {
            ninjectKernel = new StandardKernel();
            AddBindings();
        }

        protected override IController GetControllerInstance(System.Web.Routing.RequestContext requestContext, Type controllerType)
        {
            return controllerType == null ? null : (IController)ninjectKernel.Get(controllerType);
        }

        public void AddBindings()
        {
            ninjectKernel.Bind<IProduktRepository>().To<XMLProduktRepository>().WithConstructorArgument("xmlfilename",@"C:\Prywatne\Jacek Matulewski\Produkty\Produkty\Resources\produkty.xml");
        }
    }
}