﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Moq; //Mock
using Produkty.Models.Abstract;
using Produkty.Models.Entities;
using Produkty.Controllers;
using Produkty.Models.ViewModel;
using System.Web.Mvc; 


namespace TestProject1
{
    /// <summary>
    /// Summary description for UnitTest1
    /// </summary>
    [TestClass]
    public class UnitTest1
    {

        [TestMethod]
        public void WyswietlWszystkieProdukty()
        {
            //wlozymy trzy elementy (przez mock object) i sprawdzamy, czy zwraca tez trzy

            //arrange
            Mock<IProduktRepository> mock = new Mock<IProduktRepository>(); //tworzy obiekt na podstawie interfejsu
            mock.Setup(x => x.Produkty).Returns(new Produkt[] {
                new Produkt{ Id=1,Nazwa="nazwa1"},
                new Produkt{ Id=2,Nazwa="nazwa2"},
                new Produkt{ Id=3,Nazwa="nazwa3"}
            }.AsQueryable());
            ProduktController controller = new ProduktController(mock.Object);

            //act
            Produkt[] result = ((ProduktView)((ViewResultBase)controller.Produkty()).Model).Produkty.ToArray();  //dobieramy sie do modelu zwracanego przez widok

            //assert
            Assert.AreEqual(mock.Object.Produkty.Count(), result.Length);
            Assert.AreEqual("nazwa1", result[0].Nazwa);
        }

        [TestMethod]
        public void WyswietlProduktyWedlugNazwy()
        {
            //wpierw piszemy test, potem napiszemy spelniajaca go metode (TDD)

            //arrange
            Mock<IProduktRepository> mock = new Mock<IProduktRepository>(); //tworzy obiekt na podstawie interfejsu
            mock.Setup(x => x.Produkty).Returns(new Produkt[] {
                new Produkt{ Id=1,Nazwa="c"},
                new Produkt{ Id=2,Nazwa="d"},
                new Produkt{ Id=3,Nazwa="b"}
            }.AsQueryable());
            ProduktController controller = new ProduktController(mock.Object);

            //act
            Produkt[] result = ((ProduktView)((ViewResultBase)controller.ProduktySortowanePoNazwie()).Model).Produkty.ToArray();

            //assert
            Assert.AreEqual("b", result[0].Nazwa);
            Assert.AreEqual("c", result[1].Nazwa);
            Assert.AreEqual("d", result[2].Nazwa);
        }
    }
}
