﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;

namespace Kadry.Models
{
    public class Pracownik
    {
        [Required]
        [StringLength(50,ErrorMessage="Imię nie może być dłuższe niż 50 znakow")]
        public string Imie { get; set; }

        [Required]
        [StringLength(50, ErrorMessage = "Nazwisko nie może być dłuższe niż 50 znakow")]
        public string Nazwisko { get; set; }

        [Required]
        [Range(0,100,ErrorMessage="Wiek powinien być w przedziale 0 - 100")]
        public int Wiek { get; set; }

        [Required]
        [StringLength(50, ErrorMessage = "Nazwa stanowiska nie może być dłuższa niż 50 znakow")]
        public string Stanowisko { get; set; }


        [DataType(DataType.Date)]
        [DisplayName("Data zatrudnienia")]
        [CustomValidationAttribute(typeof(Pracownik),"CheckDate")]
        public DateTime DataZatrudnienia { get; set; }

        public static ValidationResult CheckDate(DateTime data)
        {
            if (data > DateTime.Now.Date)
            {
                return new ValidationResult("Data zatrudnienia nie może być późniejsza od daty dzisiejszej");
            }
            else
            {
                return ValidationResult.Success;
            }
        }
    }
}