﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nawigacja.Controllers
{
    public class MapaController : Controller
    {
        //
        // GET: /Mapa/

        public ActionResult Index()
        {
            return View();
        }

        static Nawigacja.Models.NawigacjaDatabaseEntities entities = new Models.NawigacjaDatabaseEntities();

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Index(FormCollection formularz)
        {
            if (ModelState.IsValid)
            {
                List<int> listaId = new List<int>();
                listaId = (from adres in entities.Adresy
                           where adres.IdTrasy != null
                           orderby adres.IdTrasy
                           select adres.IdTrasy).ToList();

                int idNowejTrasy;
                int tmp = listaId.Count;
                if (tmp != 0)
                {
                    idNowejTrasy = listaId[tmp - 1] + 1; //tu był błąd!
                }
                else
                {
                    idNowejTrasy = 1;
                }
                Nawigacja.Models.Adresy nowaTrasa = Nawigacja.Models.Adresy.CreateAdresy(
                    idNowejTrasy,
                    formularz["Start"].ToString(), //tu też nie działało
                    formularz["Meta"].ToString(),
                    DateTime.Now);

                entities.Adresy.AddObject(nowaTrasa);
                entities.SaveChanges(System.Data.Objects.SaveOptions.AcceptAllChangesAfterSave);
                return View(nowaTrasa);
            }

            return View();
        }

        public ActionResult wyswietlTrasy()
        {
            return View("Trasy", entities);
        }

        public ActionResult usunTrase(Nawigacja.Models.Adresy adres)
        {
            Nawigacja.Models.Adresy trasaDelete = entities.Adresy.Where(s => s.IdTrasy == adres.IdTrasy).First();
            entities.Adresy.DeleteObject(trasaDelete);
            entities.SaveChanges();

            return View("Trasy", entities);
        }
    }
}
