﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Numerics;
using System.Web;
using Web.Models;

namespace Web
{
    public class PDE
    {
        public PDE(ViewModel model)
        {
            //sieć X
            Nx = model.Nx;
            xmin = model.Xmin;
            xmax = model.Xmax;
            //Sieć T
            Nt = model.Nt;
            dt = model.dt;
            //warunki początkowe
            a = model.A;
            x0 = model.X0;
            k = model.F;
        }

        static readonly IFormatProvider formatProvider = CultureInfo.InvariantCulture;

        //sieć x
        int Nx = 0;
        double xmin = 0;
        double xmax = 0;
        double dx()
        {
            return (xmax - xmin) / (Nx - 1);
        }

        double x(int i)
        {
            return xmin + i * dx();
        }

        //sieć t
        double Nt = 0;
        double dt = 0;
        double t(int k)
        {
            return k * dt;
        }
        //warunki początkowe
        double a = 0; //szerokość
        double x0 = 0;//pozycja
        double k = 0;//wektor falowy związany z pędem

        Complex gauss(double x)
        {
            double xn = (x - x0) / (2 * a);
            return Complex.Exp(-xn * xn + Complex.ImaginaryOne * k * x);
        }

        static Complex V(double x)
        {
            return x * x;
        }

        const double h = 1; //h-kreslone
        const double m = 1; //masa elektronu

        Complex S2()
        {
            return -h * h / 2 / m / (Complex.ImaginaryOne * h);
        }
        Complex S0(double x)
        {
            return V(x) / (Complex.ImaginaryOne * h);
        }

        void zapiszPsi(Complex[] Psi, int k)
        {
            List<string> linie = new List<string>();
            for (int i = 0; i < Nx; ++i)
            {
                string s = x(i).ToString(formatProvider) + "\t" + Psi[i].Real.ToString(formatProvider) + "\t" + Psi[i].Imaginary.ToString(formatProvider) + "\t" + (Psi[i].Magnitude * Psi[i].Magnitude).ToString(formatProvider);
                linie.Add(s);
            }
            System.IO.File.WriteAllLines("Psi" + k.ToString() + ".dat", linie);
        }

        public List<string> tdse()
        {
            Complex[] A = new Complex[Nx];
            Complex[] B = new Complex[Nx];
            Complex[] C = new Complex[Nx];
            Complex[] D = new Complex[Nx];
            Complex[] Psi = new Complex[Nx];

            double norma = 0;
            for (int i = 0; i < Nx; ++i)
            {
                Psi[i] = gauss(x(i));
                norma += Psi[i].Magnitude * Psi[i].Magnitude;
            }
            norma *= dx();
            norma = Math.Sqrt(norma);
            for (int i = 0; i < Nx; ++i) Psi[i] /= norma;

            var list = new List<string>();

            for (int k = 0; k < Nt; k++)
            {
                if (k > 0)
                {
                    //obliczenia wyrazów macierzy trójdiagonalnej
                    for (int i = 0; i < Nx; ++i)
                    {
                        A[i] = -S2() / dx();
                        B[i] = 2 * dx() / dt + 2 * S2() / dx() - dx() * S0(x(i));
                        C[i] = -S2() / dx();
                        D[i] = Psi[i] * (2 * dx() / dt - 2 * S2() / dx() + dx() * S0(x(i)));
                        //warunki brzegowe
                        if (i < Nx - 1) D[i] += Psi[i + 1] * S2() / dx();
                        if (i > 0) D[i] += Psi[i - 1] * S2() / dx();
                    }

                    A[Nx - 1] = 0;
                    C[0] = 0;

                    //rozwiązywanie "układu trójprzekątniowego"
                    try
                    {
                        UkladTrojprzekatniowy.rozw3p(Nx, A, B, C, D, Psi);
                    }
                    catch (Exception exc)
                    {
                        Console.Error.WriteLine("*** Blad ****\t" + exc.Message);
                        System.Environment.Exit(1);
                    }
                }

                //if(k % 10 == 0) zapiszPsi(Psi, k);

                //obliczanie wielkosci zaleznych od czasu
                norma = 0;
                double polozenie = 0;
                //Complex ped = 0;
                for (int i = 0; i < Nx; ++i)
                {
                    double _norma = Psi[i].Magnitude * Psi[i].Magnitude;
                    norma += _norma;
                    polozenie += x(i) * _norma;
                }
                norma *= dx();
                polozenie *= dx();
                Console.WriteLine(k + "\t" + t(k).ToString(formatProvider) + "\t" + norma.ToString(formatProvider) + "\t" + polozenie.ToString(formatProvider));
                string result = (k + "\t" + t(k).ToString(formatProvider) + "\t" + norma.ToString(formatProvider) + "\t" + polozenie.ToString(formatProvider));
                list.Add(result);
            }

            return list;
        }
    }

    public static class UkladTrojprzekatniowy
    {
        public static int rozw3p(int N, Complex[] A, Complex[] B, Complex[] C, Complex[] D, Complex[] f)
        {
            if (A[N - 1].Magnitude != 0 || C[0].Magnitude != 0)
                Console.Error.WriteLine("*** Uwaga! Wartosci przekatnej A lub C poza zakresem sa niezerowe!");

            //MACIERZE DO PRZESKALOWANIA
            Complex[] X = new Complex[N];
            Complex[] Y = new Complex[N];

            //JEDNORODNE => ROZWIAZANIE TRYWIALNE
            double czy_zero = 0;
            for (int i = 0; i < N; i++) czy_zero += D[i].Magnitude * D[i].Magnitude;
            if (czy_zero == 0)
            {
                Console.Error.WriteLine("*** Ostrzezenie: Rownanie jednorodne => Rozwiazanie trywialne");
                return 1;
            }

            //PRZESKALOWYWANIE MACIERZY X,Y
            //gdy i=N: A=0
            X[N - 1] = -C[N - 1] / B[N - 1];
            Y[N - 1] = D[N - 1] / B[N - 1];
            for (int i = N - 1; i > 0; i--)
            {
                Complex mianownik = A[i] * X[i] + B[i];
                if (mianownik == 0)
                {
                    Console.Error.WriteLine("*** Dzielenie przez zero => Uklad sprzeczny");
                    throw new Exception("Uklad sprzeczny");
                }

                X[i - 1] = -C[i] / mianownik;
                Y[i - 1] = (D[i] - A[i] * Y[i]) / mianownik;
            }

            //REKURENCYJNE ROZWIAZYWANIE Z POMOCA PRZESKALOWANYCH MACIERZY
            f[0] = (D[0] - A[0] * Y[0]) / (A[0] * X[0] + B[0]);
            for (int i = 0; i < N - 1; i++) f[i + 1] = X[i] * f[i] + Y[i];

            return 0;
        }
    }
}