﻿using System.Web.Mvc;
using Web.Models;

namespace Web.Controllers
{
    public class PrettyController : Controller
    {
        public ActionResult Index()
        {
            var model = new ViewModel();

            model.Nx = 1001;
            model.Xmin = -10;
            model.Xmax = 10;
            model.Nt = 10000;
            model.dt = 0.001;
            model.A = -1;
            model.X0 = -5;
            model.F = 0;

            return View(model);
        }
        
        [HttpPost]
        public ActionResult Calculate(ViewModel model)
        {
            var pde = new PDE(model);
            model.Values = pde.tdse();

            return View("Index", model);
        }
    }
}