﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Numerics;
using System.Globalization;

namespace PDE_Int
{
    class Program
    {
        static readonly IFormatProvider formatProvider = CultureInfo.InvariantCulture;

        //sieć x
        const int Nx = 1001;
        const double xmin = -10;
        const double xmax = 10;
        const double dx = (xmax - xmin) / (Nx - 1);
        static double x(int i)
        {
            return xmin + i * dx;
        }

        //sieć t
        const double Nt = 10000;
        const double dt = 0.001;
        static double t(int k)
        {
            return k * dt;
        }

        static Complex gauss(double x) //nieunormowany
        {
            const double a = 1;
            const double x0 = -5;
            const double k = 0;
            double xn = (x - x0) / (2 * a);
            return Complex.Exp(-xn * xn + Complex.ImaginaryOne * k * x);
        }

        static Complex V(double x)
        {
            return x * x;
        }

        const double h = 1; //h-kreslone
        const double m = 1; //masa elektronu

        static readonly Complex S2 = -h * h / 2 / m / (Complex.ImaginaryOne * h);
        static Complex S0(double x)
        {
            return V(x) / (Complex.ImaginaryOne * h);
        }

        static void zapiszPsi(Complex[] Psi, int k)
        {
            List<string> linie = new List<string>();
            for (int i = 0; i < Nx; ++i)
            {
                string s = x(i).ToString(formatProvider) + "\t" + Psi[i].Real.ToString(formatProvider) + "\t" + Psi[i].Imaginary.ToString(formatProvider) + "\t" + (Psi[i].Magnitude * Psi[i].Magnitude).ToString(formatProvider);
                linie.Add(s);
            }
            System.IO.File.WriteAllLines("Psi" + k.ToString() + ".dat", linie);
        }

        static void tdse()
        {
            Complex[] A = new Complex[Nx];
            Complex[] B = new Complex[Nx];
            Complex[] C = new Complex[Nx];
            Complex[] D = new Complex[Nx];
            Complex[] Psi = new Complex[Nx];

            double norma = 0;
            for (int i = 0; i < Nx; ++i)
            {
                Psi[i] = gauss(x(i));
                norma += Psi[i].Magnitude * Psi[i].Magnitude;
            }
            norma *= dx;
            norma = Math.Sqrt(norma);
            for (int i = 0; i < Nx; ++i) Psi[i] /= norma;

            StreamWriter plik = new StreamWriter("wynik.txt");

            for (int k = 0; k < Nt; k++)
            {
                if (k > 0)
                {
                    //obliczenia wyrazów macierzy trójdiagonalnej
                    for (int i = 0; i < Nx; ++i)
                    {
                        A[i] = -S2 / dx;
                        B[i] = 2 * dx / dt + 2 * S2 / dx - dx * S0(x(i));
                        C[i] = -S2 / dx;
                        D[i] = Psi[i] * (2 * dx / dt - 2 * S2 / dx + dx * S0(x(i)));
                        //warunki brzegowe
                        if (i < Nx - 1) D[i] += Psi[i + 1] * S2 / dx;
                        if (i > 0) D[i] += Psi[i - 1] * S2 / dx;
                    }

                    A[Nx - 1] = 0;
                    C[0] = 0;

                    //rozwiązywanie "układu trójprzekątniowego"
                    try
                    {
                        PDE.UkladTrojprzekatniowy.rozw3p(Nx, A, B, C, D, Psi);
                    }
                    catch (Exception exc)
                    {
                        Console.Error.WriteLine("*** Blad ****\t" + exc.Message);
                        System.Environment.Exit(1);
                    }
                }

                //if(k % 10 == 0) zapiszPsi(Psi, k);

                //obliczanie wielkosci zaleznych od czasu
                norma = 0;
                double polozenie = 0;
                //Complex ped = 0;
                for (int i = 0; i < Nx; ++i)
                {
                    double _norma = Psi[i].Magnitude * Psi[i].Magnitude;
                    norma += _norma;
                    polozenie += x(i) * _norma;
                }
                norma *= dx;
                polozenie *= dx;
                Console.WriteLine(k + "\t" + t(k).ToString(formatProvider) + "\t" + norma.ToString(formatProvider) + "\t" + polozenie.ToString(formatProvider));
                string result = (k + "\t" + t(k).ToString(formatProvider) + "\t" + norma.ToString(formatProvider) + "\t" + polozenie.ToString(formatProvider));
                plik.WriteLine(result);

            }
           
        }

        static void Main(string[] args)
        {
            tdse();
        }
    }
}
