#include <iostream>
#include <cstdlib>
#include <fstream>
#include <stdexcept>
#include <omp.h>
#include <time.h>
#include "gnuplot_i.hpp"

using namespace std;

Gnuplot g1;
Gnuplot g2;
vector<double> t1, t2, t3, t4, t5, t6, t7, timer[9];
int N = 50000;
double rzut(int i, double* y, double t)
{
	static const double g = -9.81; //m/s^2

	double wynik = 0;
	switch (i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = -g;
		break;
	default:
		wynik = -g;
		break;
		//throw runtime_error("Zly numer rownania");
	}

	return wynik;
}

double oscylator(int i, double* y, double t)
{
	static const double k = 1;

	double wynik = 0;
	switch (i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = -y[0];
		break;
	default:
		wynik = -y[0];
		break;
		//throw runtime_error("Zly numer rownania");
	}

	return wynik;
}

double oscylatory_sprzezone(int i, double* y, double t)
{
	static const double w = 1;
	static const double b = 0;
	static const double l = 1;
	double wynik = 0;
	if (i % 2 == 0)
	{
		//poloenia
		wynik = y[i + 1];
	}
	else
	{
		//prdkoci
		wynik = -2 * b*y[i];
		if (i > 1) wynik += -w*w*(y[i - 1] - y[i - 3] - l);
		if (i < N - 1) wynik += +w*w*(y[i + 1] - y[i - 1] - l);
	}
	return wynik;
}
//solver
double* odeint_Euler(int N, double(*f)(int, double*, double), double* y, double t, double h, double* y_nast)
{
	for (int i = 0; i < N; ++i) y_nast[i] = y[i] + h * f(i, y, t);
	return y_nast;
}

double* odeint_Euler_wo(int N, double(*f)(int, double*, double), double* y, double t, double h, double* y_nast)
{
#pragma omp parallel for
	for (int i = 0; i < N; ++i) y_nast[i] = y[i] + h * f(i, y, t);
	return y_nast;
}

double* odeint_MidPoint(int N, double(*f)(int, double*, double), double* y, double t, double h, double* y_nast, clock_t actual_time, int thread_num)
{
#pragma omp_set_num_threads(thread_num)
	double* y_tmp = new double[N];
	int i = 0;
#pragma omp parallel for shared(y_tmp,y,h) private(i)
	for (i = 0; i < N; ++i)
	{
		double k1 = h * f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1;
	}
#pragma omp parallel for shared(y_nast,y,h) private(i)
	for (i = 0; i < N; ++i)
	{
		double k2 = h * f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + k2;
	}

	delete[] y_tmp;
	return y_nast;
}

double* odeint_MidPoint_w(int N, double(*f)(int, double*, double), double* y, double t, double h, double* y_nast, clock_t actual_time, int thread_num)
{
	double* y_tmp = new double[N];
	for (int i = 0; i < N; ++i)
	{
		double k1 = h * f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1;
	}
	for (int i = 0; i < N; ++i)
	{
		double k2 = h * f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + k2;
	}

	delete[] y_tmp;
	return y_nast;
}

double* odeint_RK4(int N, double(*f)(int, double*, double), double* y, double t, double h, double* y_nast)
{
	double* y_tmp = new double[N];
	double* k1 = new double[N];
	double* k2 = new double[N];
	double* k3 = new double[N];
	double* k4 = new double[N];
#pragma omp parallel for
	for (int i = 0; i < N; ++i)
	{
		k1[i] = h*f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1[i];
	}
#pragma omp parallel for
	for (int i = 0; i < N; ++i)
	{
		k2[i] = h*f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + 0.5*k2[i];
	}
#pragma omp parallel for
	for (int i = 0; i < N; ++i)
	{
		k3[i] = h*f(i, y_nast, t + 0.5*h);
		y_tmp[i] = y[i] + k3[i];
	}
#pragma omp parallel for
	for (int i = 0; i < N; ++i)
	{
		k4[i] = h* f(i, y_tmp, t + h);
		y_nast[i] = y[i] + (k1[i] + 2.0*k2[i] + 2.0*k3[i] + k4[i]) / 6.0;
	}
	delete[] k1;
	delete[] k2;
	delete[] k3;
	delete[] k4;
	delete[] y_tmp;
	return y_nast;
}

int main()
{
	cout << "ODE Int (c) UMK 2017\n";
	clock_t begin_time = clock();
	//int N = 500000;
	double* y = new double[N];
	double* y_nast = new double[N];

	fstream plik0, plik1, plik2, plik3, plik4;
	const double tmax = 20; //10s
	const double h = 0.01;

	begin_time = clock();
	double check[20];
	int counter = 0;
	double total_time[5];
	/*plik0.open("nazwa0.txt", ios::out);
	plik1.open("nazwa1.txt", ios::out);
	plik2.open("nazwa2.txt", ios::out);
	plik3.open("nazwa3.txt", ios::out);
	plik4.open("nazwa4.txt", ios::out);*/

	double thread_time[5][20];
	double diff[5][20];

	for (int i = 0; i < 5; i++)
	{
		y[0] = 0;
		y[1] = 1;
		y_nast[0] = 0;
		y_nast[1] = 0;
		counter = 0;
		begin_time = clock();

		for (double t = 0; t < tmax; t += h)
		{
			//propagacja
			//odeint_Euler(N,rzut,y,t,h,y_nast);
			//odeint_Euler(N,oscylator,y,t,h,y_nast);
			//odeint_RK4(N, oscylator, y, t, h, y_nast);
			//if(i==0)
			//	odeint_MidPoint_w(N, oscylatory_sprzezone, y, t, h, y_nast, begin_time, i);
			//else
				odeint_MidPoint(N, oscylatory_sprzezone, y, t, h, y_nast, begin_time, i);

			//cout << t << "\t" << y[0] << "\t" << y[1] << "\n";

			if ((int)t == counter)
			{
				if (i == 0)
					check[counter] = y[0];

				timer[i].push_back(double(clock() - begin_time) / 1000);
				thread_time[i][(int)t] = y[0];
				counter++;

			}

			//zamiana tablic miejscami
			double* y_tmp = y;
			y = y_nast;
			y_nast = y_tmp;
		}
		total_time[i] = double(clock() - begin_time) / 1000;
		t1.push_back(i);
		t2.push_back(total_time[i]);
	}

	for (int i = 0; i < 20; i++)
	{
		t3.push_back(thread_time[0][i] - thread_time[0][i]);
		t4.push_back(thread_time[1][i] - thread_time[0][i]);
		t5.push_back(thread_time[2][i] - thread_time[0][i]);
		t6.push_back(thread_time[3][i] - thread_time[0][i]);
		t7.push_back(thread_time[4][i] - thread_time[0][i]);
	}

	g2.set_yrange(-1, 1);
	g1.set_style("lines").plot_xy(t1, t2, "T/Liczba watkow");
	g2.set_style("lines").plot_xy(timer[0], t3, "x0");
	g2.set_style("lines").plot_xy(timer[1], t4, "x1 - x0");
	g2.set_style("lines").plot_xy(timer[2], t5, "x2 - x0");
	g2.set_style("lines").plot_xy(timer[3], t6, "x3 - x0");
	g2.set_style("lines").plot_xy(timer[4], t7, "x4 - x0");

	for (int i = 0; i < 5; i++)
		cout << "Czas obliczen dla " << i << " watkow wynosi: " << total_time[i] << endl;

	//plik.close();
	delete[] y;
	delete[] y_nast;

	system("pause");
	return 0;
}