//Wykona symulacj piki zbudowanej z sieci punktw materialnych.
//   W symulacji uwzgldni cinienie powietrza wewntrz piki (zaley
//   jedynie od objtoci piki), ktre rozpycha punktu na zewntrz
//   i rwnoway si cienia.
#include <iostream>
#include <cstdlib>
#include <cmath>
#include <fstream>
#include <ctime>
#include <iomanip>

#define M_PI 3.14159265358979323846

using namespace std;

double objetosc(double r) //objetosc
{
	return 4.0/3.0*M_PI*pow(r,3.0);
}

double masamolowa(double O, double N) //masa molowa 
{
	O=0.0032;
	N=0.0028;
	return 0.2*O+0.8*N;
}

double wspolczynnika(double Mgazu, double V, double R, double T) //wspolczynnik nachylenia krzywej
{
	return (Mgazu*V)/(R*T);
}

double masagazu(double a, double P) //masa gazu=wspolczynnik nachylenia krzywej*cisnienie
{
	return a*P;
}

double masacalkowita(double mgazu, double mpilki) //masa calkowita=masa gazu+masa pilki
{
	return mgazu+mpilki;
}

double iloscgazu(double mgazu, double Mgazu) //ilosc gazu=masa gazu/Masa molowa gazu
{
	return mgazu/Mgazu;
}

double cisnienie(double V, double n, double R, double T) //cisnienie
{
	return (n*R*T)/V;
}

double ciezar(double m, double g)
{
	return m*g;
}

void ukladpunktowmaterialnych()
{
	double M, r, v, psm, Fzew; //M - masa ukladu, r - srodek masy, v - predkosc srodka masy, psm - ped srodka masy, Fzew - sila wypadkowa sil zewnetrznych
	double xn, yn, zn; //wspolrzedne srodka masy ukladu
    int n=100;
	double masa[n]; 
	
	fstream punkty, srodek;
	
	for(int i=0; i<n; i++)
        masa[i] = ((double)rand() / (RAND_MAX + 0.04));
        
	M = 0; 
	for (int i = 0; i < n; i++)
		M += masa[i];
	
	double x[n]; 
	double y[n]; 
	double z[n];
	for(int i=0; i<n; i++)
	{
		punkty.open("punkty.txt", ios::out | ios::app);
		
		x[i] = ((double)rand() / (RAND_MAX + 0.09));
		y[i] = ((double)rand() / (RAND_MAX + 0.09));
		z[i] = ((double)rand() / (RAND_MAX + 0.09));
		
		punkty << x[i] << fixed << setprecision(2) << "\t" << y[i] << fixed << setprecision(2) << "\t" << z[i] << fixed << setprecision(2) << endl;
		
		punkty.close();
	}
        
    for(int i=0;i<n;i++)
    	r=r+((masa[i]*x[i]*y[i]*z[i])/M);
    
    double p[n]; 
	for(int i=0; i<n; i++)
        p[i] = ((double)rand() / (RAND_MAX + 0.04));
    
    for(int i=0;i<n;i++)
    	v=v+(p[i]/M);
    
    for(int i=0;i<n;i++)
    	psm=psm+p[i];
    
    for(int i=0;i<n;i++)
    {
    	xn=xn+((masa[i]*x[i])/M);
    	yn=yn+((masa[i]*y[i])/M);
    	zn=zn+((masa[i]*z[i])/M);
	}
    
    cout << "Masa ukladu = " << M << " kg" << endl;
    cout << "Srodek masy = " << r << endl;
    cout << "Predkosc srodka masy = " << v << " m/s" << endl;
    cout << "Ped srodka masy = " << psm << " kg m/s2" << endl;
    psm=Fzew;
    cout << "Sila wypadkowa sil zewnetrznych = " << Fzew << endl;
    
    srodek.open("srodek.txt", ios::out | ios::app);
    cout << "Wspolrzedne srodka masy ukladu = [" << xn << ", " << yn << ", " << zn << "]" << endl;
    srodek << xn << "\t" << yn << "\t" << zn << endl;
    srodek.close();
}

int main()
{
	double P=100000, V, n, R=8.3144598, T=293, r=0.093, m, mpilki=0.408, mgazu, Mgazu, a, O, N, g=9.81, Fg;	
	fstream plik;
	
	srand(time(NULL));
	
	cout << "Symulacji pilki" << endl;
	cout << "" << endl;
	cout << "P - cisnienie pilki [Pa]" << endl;
	cout << "V - objetosc pilki [m3]" << endl;
	cout << "n - ilosc gazu [mol]" << endl;
	cout << "R - stala gazowa [J/mol*K]" << endl;
	cout << "T - temperatura [T]" << endl;
	cout << "r - promien kuli (pilki) [m]" << endl;
	cout << "mpilki - masa pilki [kg]" << endl;
	cout << "mgazu - masa gazu [kg]" << endl;
	cout << "m - masa calkowita [kg]" << endl;
	cout << "g - przyspieszenie ziemskie [ms/s2]" << endl;
	cout << "Fg - ciezar [N]" << endl;
	cout << "Mgazu - masa molowa gazu [kg/mol]" << endl;
	cout << "a - wspolczynnik nachylenia krzywej [kg/Pa]" << endl;
	cout << "O - tlen, N - azot" << endl;
	cout << "" << endl;
	
	V=objetosc(r);
	cout << "V=" << V << " m3" << endl;
	Mgazu=masamolowa(O, N);
	cout << "Mgazu=" << Mgazu << " kg/mol" << endl;
	a=wspolczynnika(Mgazu, V,  R, T);
	cout << "a=" << a << " kg/Pa" << endl;
	mgazu=masagazu(a, P);
	cout << "mgazu=" << mgazu << " kg" << endl;
	m=masacalkowita(mgazu, mpilki);
	cout << "m=" << m << " kg" << endl;
	n=iloscgazu(mgazu, Mgazu);
	cout << "n=" << n << " mol" << endl;
	Fg=ciezar(m, g);
	cout << "Fg=" << Fg << " N" << endl;
	cout << "" << endl;
	
	cout << "" << endl;
	ukladpunktowmaterialnych();
	cout << "" << endl;
	
	while(V<1)
	{
		plik.open("wyniki.txt", ios::out| ios::app);
		P=cisnienie(V, n, R, T);
		cout << " Cisnienie pilki wynosi: " << P << " Pa" << " Objetosc pilki wynosi: " << V << " m3" << endl;	
		plik << P << " " << V << endl;
		V=V+0.01;
		plik.close();
	}
	
	return 0;
}
