#pragma once

#include <functional>

namespace rk_sse {
	template<uint dim>
	void rk2(double *, double *, std::function<void(double *, double *)>, double);

	template<>
	void rk2<1>(double * in, double * out, std::function<void(double *, double *)> step, double h) {
		static double _step[2];

		step(in, _step);

		asm volatile (
			"movdqa (%[in]), %%xmm15\n"
			"movdqa (%[step]), %%xmm14\n"
			"movddup %[h], %%xmm13\n"
			"movddup %[half], %%xmm12\n"
			"mulpd %%xmm13, %%xmm14\n"
			"mulpd %%xmm12, %%xmm14\n"
			"addpd %%xmm15, %%xmm14\n"
			"movdqa %%xmm14, (%[step])\n"
			:
			: [in] "r" (in), [step] "r" (_step), [h] "x" (h), [half] "x" (0.5)
		);

		step(_step, _step);

		asm volatile (
			"movdqa (%[step]), %%xmm14\n"
			"mulpd %%xmm13, %%xmm14\n"
			"addpd %%xmm14, %%xmm15\n"
			"movdqa %%xmm15, (%[out])\n"
			:
			: [step] "r" (_step), [out] "r" (out)
		);
	}
}
