#pragma once

#include <functional>

namespace rk_sse {
	template<uint dim>
	void rk1(double *, double *, std::function<void(double *, double *)>, double);

	template<>
	void rk1<1>(double * in, double * out, std::function<void(double *, double *)> step, double h) {
		static double _step[2];

		step(in, _step);

		asm volatile (
			"movdqa (%[in]), %%xmm15\n"
			"movdqa (%[step]), %%xmm14\n"
			"movddup %[h], %%xmm13\n"
			"mulpd %%xmm13, %%xmm14\n"
			"addpd %%xmm14, %%xmm15\n"
			"movdqa %%xmm15, (%[out])"
			: 
			: [in] "r" (in), [step] "r" (_step), [h] "x" (h), [out] "r" (out)
		);
	}
}
