#include <iostream>
#include <iomanip>
#include <cmath>
#include "statevector_sse.hpp"
#include "statevector.hpp"

// http://jmahaffy.sdsu.edu/courses/f14/math124/beamer_lectures/num_de.pdf

class MalthusEquation1 : public rk_sse::StateVector<1, 1> {
	protected:
		virtual rk_sse::Vector_SSE<2> step(rk_sse::Vector_SSE<2> x) override {
			rk_sse::Vector_SSE<2> out;
			out[0] = (birthFactor - deathFactor) * x[0];

			return out;
		}	
	
	public:
		double birthFactor;
		double deathFactor;
		
		MalthusEquation1(double h) : StateVector(h) {
			birthFactor = 0;
			deathFactor = 0;
		}
};

class MalthusEquation2 : public rk_sse::StateVector_SSE<1, 1> {
	protected:
		virtual void step(double * in, double * out) override {
			out[0] = (birthFactor - deathFactor) * in[0];
		}
	
	public:
		double birthFactor;
		double deathFactor;
		
		MalthusEquation2(double h) : StateVector_SSE(h) {
			birthFactor = 0;
			deathFactor = 0;
		}
};
		
int main(int argc, char * argv[]) {
	MalthusEquation1 malthus(0.001);
	malthus.maxError = 1e-5;
	malthus.birthFactor = 0.03;
	malthus.deathFactor = 0.01;
	double initialPopulation = 1;
	
	malthus[0] = initialPopulation;
	
	for(uint i = 0; i <= 10000000; i++) {
		double calculated = malthus[0];
		double ideal = initialPopulation * std::exp(i * 0.001 * (malthus.birthFactor - malthus.deathFactor));
		
		std::cout << std::fixed << std::setprecision(8) << i * 0.001 << '\t' << calculated << '\t'
				  << ideal << '\t' << std::abs(ideal - calculated) << std::endl;
				  
		malthus.RK1SolverUpdate();
	}
	
	return 0;
}

/*
 * źródła
 * porównanie wyników - czy O2 zrównolegla 
 * przyspieszenie
 */
