﻿using UnityEngine;
using System.Collections;

public class PlanetaryOrbit : MonoBehaviour
{
	public float[] parametry_planet { get; set; }
    //eccentricity , rpericenter ,  orbital period,  radius, axial tilt, rot pediod longtitude of ascending node

    private float[] CosSinOmega = new float[2];

	public float OP { get; private set; }		//orbital period
	public float RP { get; private set; }		// roation period

	public float Zwracanie_predkosci_po_przeliczeniach_jednostek ()
	{
		return Parametryzacja_predkosci ().magnitude * Scales.velmu2kms;
	}

	private const int N = 30000;
	private float[] katy = new float[N];
	private float surface;
	private float k;
	private float orbitDt;

	public float Theta {
		get { return Teta (time); }
	}

	public float time;

	void Start ()
	{
        //OP == orbital period
        OP = parametry_planet [2] * Scales.y2tmu;

        //rp rot pediod
        RP = parametry_planet [5] * Scales.y2tmu;

        // Powierzchnia = 
        surface = Mathf.Sqrt (-(1 + parametry_planet [0]) / Mathf.Pow (-1 + parametry_planet [0], 3)) * Mathf.PI * parametry_planet [1] * parametry_planet [1];
		k = 2 * surface / (Mathf.Pow (1 + parametry_planet [0], 2) * OP * parametry_planet [1] * parametry_planet [1]);
        //Orbit dt
		orbitDt = OP / (2 * (N - 1));
        //Algorytm orbitalny
		ThetaRunge ();
        //time = Random.Range (0, OP);
        //longtitude of ascending node
        CosSinOmega[0] = Mathf.Cos (parametry_planet [6]);
		CosSinOmega [1] = Mathf.Sin (parametry_planet [6]);
	}
    //
	void FixedUpdate ()
	{
		if (Scales.Pause == false) {
			time += Time.fixedDeltaTime;
			transform.localPosition = Parametryzacja_orbit (Teta (time));
		}
	}

	public Vector3 GetPositionAfterTime (float t)
	{
		return Parametryzacja_orbit (Teta (time + t));
	}

	public Vector3 Parametryzacja_orbit (float th)
	{
       // współrzędne orbitalne
        float x, z;
        x = (parametry_planet[1] * (1 + parametry_planet[0])) / (1 + parametry_planet[0] * Mathf.Cos(th)) * Mathf.Cos (th);
        z = (parametry_planet[1] * (1 + parametry_planet[0])) / (1 + parametry_planet[0] * Mathf.Cos(th)) * Mathf.Sin(th);
        //szukane   współrzędne       geocentryczne satelity
        float p_x, p_y;
        p_x = CosSinOmega [0] * x - CosSinOmega [1] * z;
		 p_y = CosSinOmega [1] * x + CosSinOmega [0] * z;
		return new Vector3 (p_x, 0f, p_y);
	}
    //Obliczanie pochodnej 
	private float dthdt (float theta)
	{
		return k * Mathf.Pow ((1 + parametry_planet [0] * Mathf.Cos (theta)), 2);
	}
    //Zwykla metoda
    /*
	private void Theta ()
	{
		katy [0] = 0; 

		for (int i = 0; i < N - 2; i++)
			katy [i + 1] = orbitDt * dthdt (katy [i]) + katy [i];

		katy [N - 1] = Mathf.PI;
	}
    */

    private void ThetaRunge ()
	{
		float w = 0, k1, k2, k3, k4;
		for (int i = 0; i < N - 2; i++) {
			k1 = orbitDt * dthdt (w);
			k2 = orbitDt * dthdt (w + k1 / 2);
			k3 = orbitDt * dthdt (w + k2 / 2);
			k4 = orbitDt * dthdt (w + k3);
			w = w + (k1 + 2 * k2 + 2 * k3 + k4) / 6;
            //theta(i)    
            katy [i + 1] = w;
		}
		katy [N - 1] = Mathf.PI;
	}



    //Obliczanie tety
	public float Teta (float t)
	{
		float theta = 0;
		t = t % OP;

		if (t <= OP / 2) {
			float i = t / orbitDt;
			float i0 = Mathf.Clamp (Mathf.Floor (i), 0, N - 1);
			float i1 = Mathf.Clamp (Mathf.Ceil (i), 0, N - 1);


			if (i0 == i1)
				theta = katy [(System.Int64)i0];
			else {
				theta = (katy 
                    [(System.Int64)i0] - katy [(System.Int64)i1]) / 
                    (i0 - i1) * i + (i0 * katy [(System.Int64)i1]
                    - katy [(System.Int64)i0] * i1) / (i0 - i1);
			}
			return theta;
		} else {
			t = -t + OP;
			float i = t / orbitDt;
			float i0 = Mathf.Clamp (Mathf.Floor (i), 0, N - 1);
			float i1 = Mathf.Clamp (Mathf.Ceil (i), 0, N - 1);

			if (i0 == i1)
				theta = -katy [(System.Int64)i0] + 2 * Mathf.PI;
			else {
				theta = -((katy [(System.Int64)i0] - katy [(System.Int64)i1]) / (i0 - i1) * i + (i0 * katy [(System.Int64)i1] - katy [(System.Int64)i0] * i1) / (i0 - i1)) + 2 * Mathf.PI;
			}
			return theta;
		}
	}
    //Parametryzowanie predkosci
	public Vector3 Parametryzacja_predkosci ()
    {

      //  # update the elapsed time
        // $time = $time + $dt;

        float myfixedDt = 2 * orbitDt;
		Vector3 pos2 = Parametryzacja_orbit (Teta (time + myfixedDt));
		Vector3 pos1 = Parametryzacja_orbit (Teta (time - myfixedDt));

		return new Vector3 ((pos2.x - pos1.x) / (2 * myfixedDt), 0.0f, (pos2.z - pos1.z) / (2 * myfixedDt));
	}
}