﻿using ODE;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Symulacja
{
    public partial class Form1 : Form
    {
        ModelSethi modelSethi { get; set; }
        float[,] sethiResult { get; set; }
        public Form1()
        {
            InitializeComponent();
        }

        private async void button1_Click(object sender, EventArgs e)
        {

            chart1.Series.Clear();
            this.chart1.ChartAreas[0].AxisX.Minimum = 0.0;
            this.chart1.ChartAreas[0].AxisX.Maximum = 100.0;
            this.chart1.ChartAreas[0].AxisX.Interval = 10;
            //this.chart1.ChartAreas[0].AxisY.Minimum = 0;
            //this.chart1.ChartAreas[0].AxisY.Maximum = 1;
            //this.chart1.ChartAreas[0].AxisX2.Maximum = 100;
            this.chart1.ChartAreas[0].AxisX.RoundAxisValues();
            var series1 = new System.Windows.Forms.DataVisualization.Charting.Series
            {
                Name = "Series1",
                Color = System.Drawing.Color.Green,
                IsVisibleInLegend = false,
                IsXValueIndexed = true,
                ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.FastLine
            };

            this.chart1.Series.Add(series1);
            //this.chart1.ChartAreas[0].AxisX.MaximumAutoSize = 100;

            this.sethiResult = await SethiSolve();
            for(int i=0; i< 100; i++)
            {
                series1.Points.AddXY(sethiResult[i, 0], sethiResult[i, 1]);
            }
            //this.chart1.ChartAreas[0].AxisX.MaximumAutoSize = 100;
            chart1.Invalidate();



        }

        private Task<float[,]> SethiSolve()
        {
            float advertise = (float) trackBar1.Value / 100;
            float obsolence = (float) trackBar2.Value / 100;
            float brand = (float) trackBar3.Value / 100;
            modelSethi = new ModelSethi(brand, obsolence, advertise);
            return Task<float[,]>.Factory.StartNew(() => modelSethi.Solve());
        }

    }
}
