﻿using System;
using System.IO;
using System.Collections.Generic;
using Microsoft.Research.Oslo;
using System.Diagnostics;
using System.Globalization;
using System.Linq;

namespace ODE
{
    public class ModelSethi
    {
        private float brandStrength { get; set; }
        private float obsolence { get; set; }
        private float advertisementRank { get; set; }

        public ModelSethi(float brandStrength, float obsolence, float advertisementRank)
        {
            this.brandStrength = brandStrength;
            this.obsolence = obsolence;
            this.advertisementRank = advertisementRank;
        }

        public float[,] Solve()
        {
            int i = 0;
            float[,] sethi = new float[110,2];
            foreach (var sp in Ode.GearBDF(0, 1,
                (t, x) => this.brandStrength * this.advertisementRank * Math.Sqrt(1 - x) - (double) obsolence * x
                //new Options { RelativeTolerance = 1e-3 })
                ).SolveFromToStep(0, 100, 1).ToArray())
            {
                // Console.WriteLine("{0}\t{1}", sp.T, sp.X);
                sethi[i,0] = (float) sp.T;
                sethi[i,1] = (float) sp.X;
                i++;
            }

            return sethi;
        }


    }
}
