
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>


void Wczytywanie_z_pliku(double tablica[]){
		
   FILE *plik;
   int liczba,i=0;
   char parametr[50];
   char nazwa[20];
   WCZYTAJ:
   printf("Podaj nazwe pliku z parametrami:\n");
   scanf("%s", &nazwa);
   plik = fopen(nazwa,"r");
   if (plik == NULL) 
   {
      printf("Blad otwarcia pliku \n");
      goto WCZYTAJ;
   }
 
   while(feof(plik) == 0)
   {
   	fscanf(plik,"%s",&parametr);
   	switch(i){
	    case 1:
         tablica[0]= atof(parametr);
         break;
        case 3:
         tablica[1]= atof(parametr);
         break;
        case 5:
         tablica[2]= atof(parametr);
         break;
        case 7:
         tablica[3]= atof(parametr);
         break;
        case 9:
         tablica[4]= atof(parametr);
         break;
        case 11:
         tablica[5]= atof(parametr);
         break;
        case 13:
         tablica[6]= atof(parametr);
         break; 
        case 15:
         tablica[7]= atof(parametr);
         break; 
        default:
         break;
    }
      i++;
   }
   fclose(plik);
}




double Wzory(int nr, double V, double P, double r, double a, double b, double s, double K, double K2){
	double wzor;
	
	if(nr==1) wzor=V*(r-a*P); //standardowy dla ofiar
	if(nr==2) wzor=P*(a*b*V-s); //standardowy dla drapienikw
	if(nr==3) wzor=V*(r*(1-(V/K))-a*P); //dla ofiar z pojemnoci rodowiskow
	if(nr==4) wzor=r*V-(a*(V-K)*P); //dla ofiar z kryjwk
	if(nr==5) wzor=P*(a*b*(V-K)-s); //dla drapienikw z kryjwkami
	if(nr==6) wzor=r*V*(1 - (V/K) - (a*P/K2)); //dla konkurencji
	if(nr==7) wzor=r*V*(1 - (V/K) + (a*P));  //dla symbiozy
	
	return wzor;
}

double Euler(int nr, double h, double V, double P, double r, double a, double b, double s, double K, double K2){
	double k1, dt;
	k1=h*Wzory(nr, V, P, r, a, b, s, K, K2);
	dt = k1;
	
	return dt;	
}

double Runge_Kutta_2(int nr, double h, double V, double P, double r, double a, double b, double s, double K, double K2){
	double k1,k2,dt;
	k1=h*Wzory(nr, V, P, r, a, b, s, K, K2);
	k2=h*Wzory(nr, (V+k1/2), (P+h/2), r, a, b, s, K, K2);
	dt = k2;
	
	return dt;	
}

double Runge_Kutta_4(int nr, double h, double V, double P, double r, double a, double b, double s, double K, double K2){
	double k1,k2,k3,k4, dt;
	k1=h*Wzory(nr, V, P, r, a, b, s, K, K2);
	k2=h*Wzory(nr, (V+k1/2), (P+h/2), r, a, b, s, K, K2);
	k3=h*Wzory(nr, (V+k2/2), (P+h/2), r, a, b, s, K, K2);
	k4=h*Wzory(nr, (V+k3), (P+h), r, a, b, s, K, K2);
	dt = (k1+2*k2+2*k3+k4)/6;
	
	return dt;	
}

int main(){
    double tablica[8];
    while(1){
	
    Wczytywanie_z_pliku(tablica);
	double V = tablica[0];
	double P = tablica[1];
	double r = tablica[2];
	double a = tablica[3];
	double b = tablica[4];
	double s = tablica[5];
	double K = tablica[6];
	double K2 = tablica[7];
	double t = 200000;
	double h = 0.001;
	double wyniki[2];
    double dV, dP;
	int x;
	
	   FILE *plik2;
	   plik2 = fopen("Wyniki.txt","w");
	   
	printf("Jaki rodzaj symulacji przeprowadzic?:\n\n");
	printf("1. Drapienik-ofiara\n");
	printf("2. Drapienik-ofiara z limitem rodowiskowym\n");
	printf("3. Drapienik-ofiara z kryjwkami dla ofiar\n");
	printf("4. Konkurencja\n");
	printf("5. Symbioza\n");
	scanf("%d",&x);
	
	for(int i=0; i<t; i++){
		fprintf(plik2,"%d     %f      %f\n", i, V, P);
		switch(x){
			case 1:
				dV=Runge_Kutta_4(1, h, V, P, r, a, b, s, K, K2);
		        dP=Runge_Kutta_4(2, h, V, P, r, a, b, s, K, K2);
				break;
			case 2:
				dV=Runge_Kutta_4(3, h, V, P, r, a, b, s, K, K2);
		        dP=Runge_Kutta_4(2, h, V, P, r, a, b, s, K, K2);
				break;
			case 3:
				dV=Runge_Kutta_4(4, h, V, P, r, a, b, s, K, K2);
		        dP=Runge_Kutta_4(5, h, V, P, r, a, b, s, K, K2);
				break;	
			case 4:
				dV=Runge_Kutta_4(6, h, V, P, r, a, b, s, K, K2);
		        dP=Runge_Kutta_4(6, h, P, V, b, s, r, a, K2, K);
				break;
			case 5:
				dV=Runge_Kutta_4(7, h, V, P, r, a, b, s, K, K2);
		        dP=Runge_Kutta_4(7, h, P, V, b, s, r, a, K2, K);
				break;			
			default:
				break;
		}
		V=V+dV;
		P=P+dP;
		
    }
	
	fclose(plik2);
	system("gnuplot -p -e \"plot 'Wyniki.txt' using 1:2 title 'V' with lines lw 2, 'Wyniki.txt' using 1:3 title 'P' with lines lw 2 \"");
    system("gnuplot -p -e \"plot 'Wyniki.txt' using 2:3 title 'V' with lines lw 2 \"");
	system("cls");
    }
    

    
	return 0;
}
