﻿using UnityEngine;
using UnityEngine.UI;

public class UIController : MonoBehaviour
{
    // defaults
    public float StructuralSpringConstant;
    public float ShearSpringConstant;
    public float BendSpringConstant;
    public float DragDampingConstant;
    public float WindBaseForceConstant;
    public float WindSwayForceConstant;

    public Text StructuralSpringText;
    public Slider StructuralSpringSlider;
    public Text ShearSpringText;
    public Slider ShearSpringSlider;
    public Text BendSpringText;
    public Slider BendSpringSlider;
    public Text DragDampingText;
    public Slider DragDampingSlider;
    public Text WindBaseForceText;
    public Slider WindBaseForceSlider;
    public Text WindSwayForceText;
    public Slider WindSwayForceSlider;

    private void Awake()
    {
        SetStructuralSpringConstant(StructuralSpringConstant);
        SetShearSpringConstant(ShearSpringConstant);
        SetBendSpringConstant(BendSpringConstant);
        SetDragDampingConstant(DragDampingConstant);
        SetWindBaseForceConstant(WindBaseForceConstant);
        SetWindSwayForceConstant(WindSwayForceConstant);
    }

    public void SetStructuralSpringConstant(float value)
    {
        Particle.StructuralSpringConstant = value;
        StructuralSpringText.text = value.ToString("F");
        StructuralSpringSlider.value = value;
    }

    public void SetShearSpringConstant(float value)
    {
        Particle.ShearSpringConstant = value;
        ShearSpringText.text = value.ToString("F");
        ShearSpringSlider.value = value;
    }

    public void SetBendSpringConstant(float value)
    {
        Particle.BendSpringConstant = value;
        BendSpringText.text = value.ToString("F");
        BendSpringSlider.value = value;
    }

    public void SetDragDampingConstant(float value)
    {
        Particle.DragDampingConstant = value;
        DragDampingText.text = value.ToString("F");
        DragDampingSlider.value = value;
    }

    public void SetWindBaseForceConstant(float value)
    {
        Environment.WindBaseForce = value;
        WindBaseForceText.text = value.ToString("F");
        WindBaseForceSlider.value = value;
    }

    public void SetWindSwayForceConstant(float value)
    {
        Environment.WindSwayForce = value;
        WindSwayForceText.text = value.ToString("F");
        WindSwayForceSlider.value = value;
    }
}
