﻿using UnityEngine;

public class Environment : MonoBehaviour
{
    public static float WindBaseForce;
    public static float WindSwayForce;

    private void Awake()
    {
        Time.timeScale = 1f;
        Time.fixedDeltaTime =  Time.timeScale / 50f;
    }

    public static Vector3 WindForce
    {
        get
        {
            return new Vector3(WindBaseForce, 0, Mathf.Sin(Time.fixedTime * 2) * WindSwayForce);
        }
    }

    public static Vector3 Gravity { get { return new Vector3(0, -9.81f, 0); } }
}