﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Timers;
using System.Windows.Media.Media3D;
using System.Numerics;

namespace OstatecznaWersjaPPN
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Timer timer;

        float promieńPołokręgu = 300;
        Vector2 VektorPozycjiOkręgu = new Vector2(300,300);
        Vector2 VektorPozycjiOkręgu2 = new Vector2(300, 600);
        Ball kulka = new Ball();

        bool gravity = false;
        float acc=10, t=0;

        Vector2 vektorD;  // wektor odbijany
        Vector2 vektorN;   //wektor od środka półokręgu do środka kuli
        float speed = 8;
        DateTime startTime = DateTime.Now;


        public MainWindow()
        {
            InitializeComponent();
            timer = new Timer(10);
            timer.Elapsed += Timer_Elapsed;
            timer.Start();   
            myCanvas.Children.Add(kulka.path);

        }

        private void Timer_Elapsed(object sender, ElapsedEventArgs e)
        {
            wykrywanieKolizji();
            kulka.VektorPozycjiKuli.X += kulka.Velocity.X;
            kulka.VektorPozycjiKuli.Y += kulka.Velocity.Y;
         

            this.Dispatcher.Invoke(() => { textbox.Text ="\nX: "+ kulka.VektorPozycjiKuli.X.ToString() + "  Y: " + kulka.VektorPozycjiKuli.Y.ToString() +"\n\nVx: " + kulka.Velocity.X.ToString() + "  Vy: " + kulka.Velocity.Y.ToString(); } );
            this.Dispatcher.Invoke(() => { 
                kulka.path.Data.SetValue(EllipseGeometry.CenterProperty, new Point(kulka.VektorPozycjiKuli.X, kulka.VektorPozycjiKuli.Y));
               
            });
        }
      
        private void wykrywanieKolizji()
        {
           
            Vector2 VektorNastePnejPozycjiKulki = new Vector2(kulka.VektorPozycjiKuli.X + kulka.Velocity.X, kulka.VektorPozycjiKuli.Y + kulka.Velocity.Y);

            if ((VektorNastePnejPozycjiKulki.X - kulka.promieńKulki <= 0 || VektorNastePnejPozycjiKulki.X + kulka.promieńKulki >= 600) && (VektorNastePnejPozycjiKulki.Y > 300 && VektorNastePnejPozycjiKulki.Y < 600)) //kolizja z lewą i prawą ścianą
                kulka.Velocity.X *= -1;
            if (VektorNastePnejPozycjiKulki.Y<=300 && promieńPołokręgu <= kulka.promieńKulki + odległośćMiędzyPunktami(VektorPozycjiOkręgu, VektorNastePnejPozycjiKulki)) // górny połokrąg
            {
                vektorN = VektorPozycjiOkręgu - VektorNastePnejPozycjiKulki;
                vektorN = Vector2.Normalize(vektorN);
                vektorD = kulka.Velocity;
                kulka.Velocity = Vector2.Reflect(vektorD, vektorN );
          
            }

            else if (VektorNastePnejPozycjiKulki.Y >= 600 && promieńPołokręgu <= kulka.promieńKulki + odległośćMiędzyPunktami(VektorPozycjiOkręgu2, VektorNastePnejPozycjiKulki)) //dolny połokrąg
            {
                vektorN = VektorNastePnejPozycjiKulki - VektorPozycjiOkręgu2 ;
                vektorN = Vector2.Normalize(vektorN);
                vektorD = kulka.Velocity;
                kulka.Velocity = Vector2.Reflect(vektorD, vektorN);
              
            }

            //środkowy prostokąt
            else if (VektorNastePnejPozycjiKulki.X + kulka.promieńKulki >= 200 && VektorNastePnejPozycjiKulki.X - kulka.promieńKulki <= 400 && VektorNastePnejPozycjiKulki.Y + kulka.promieńKulki >= 300 && VektorNastePnejPozycjiKulki.Y - kulka.promieńKulki <= 600) //sprawdzamy czy nastapilo zderzenie z prostokątem 
            {
                kulka.Velocity.Y *= -1;
                VektorNastePnejPozycjiKulki.X += kulka.Velocity.X;
                VektorNastePnejPozycjiKulki.Y += kulka.Velocity.Y;
                if(VektorNastePnejPozycjiKulki.X + kulka.promieńKulki >= 200 && VektorNastePnejPozycjiKulki.X - kulka.promieńKulki <= 400 && VektorNastePnejPozycjiKulki.Y + kulka.promieńKulki >= 300 && VektorNastePnejPozycjiKulki.Y - kulka.promieńKulki <= 600)
                {
                    kulka.Velocity.Y *= -1;
                    kulka.Velocity.X *= -1;
                }

            }

           
        }
        private double odległośćMiędzyPunktami(Vector2 Vektor1, Vector2 Vektor2)
        {
            double x = Math.Sqrt(Math.Pow(Vektor1.X - Vektor2.X, 2) + Math.Pow(Vektor1.Y - Vektor2.Y, 2)); ;
            return x;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            kulka.Velocity.X = kulka.Velocity.X >= 0 ?  float.Parse(texBoxSpeed.Text) :  -float.Parse(texBoxSpeed.Text);
            kulka.Velocity.Y = kulka.Velocity.Y >= 0 ?  float.Parse(texBoxSpeed.Text) :  -float.Parse(texBoxSpeed.Text);
        }

       
    }
}
