﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Numerics;

namespace PDE_Piatek
{
    using PDE;

    class Program
    {
        //sieć x
        const int Nx = 1001;
        const double xmin = -10;
        const double xmax = 10;
        const double dx = (xmax - xmin) / (Nx - 1);
        static double x(int i)
        {
            return xmin + i * dx;
        }

        //sieć t
        const int Nt = 1000;
        const double dt = 0.01;
        static double t(int k)
        {
            return k * dt;
        }

        //warunki poczatkowe
        static Complex gauss(double x)
        {
            const double a = 1; //szerokość
            double x0 = -5; //pozycja
            double k = 0; //wektor falowy, związany z pędem
            double xn = (x - x0) / (2 * a);
            return Complex.Exp(-xn * xn + Complex.ImaginaryOne * k * x);
        }

        static Complex V(double x)
        {
            const double k = 1;
            return k * x * x;
        }

        //stałe fizyczne -> jednostki
        const double h = 1; //h kreślone        
        const double m = 1;
        static readonly Complex S2 = -h * h / (2 * m) / (Complex.ImaginaryOne * h);
        static Complex S0(double x)
        {
            return V(x) / (Complex.ImaginaryOne * h);
        }

        static readonly IFormatProvider formatProvider = System.Globalization.CultureInfo.InvariantCulture;

        static void Main(string[] args)
        {
            Complex[] A = new Complex[Nx];
            Complex[] B = new Complex[Nx];
            Complex[] C = new Complex[Nx];
            Complex[] D = new Complex[Nx];
            Complex[] Psi = new Complex[Nx];

            //warunki początkowe i normowanie
            double norma = 0;
            for (int i = 0; i < Nx; ++i)
            {
                Psi[i] = gauss(x(i));
                norma += Psi[i].Norm();
            }
            norma *= dx;
            norma = Math.Sqrt(norma);
            for (int i = 0; i < Nx; ++i) Psi[i] /= norma;

            //ewolucja
            for (int k = 0; k <= Nt; ++k)
            {
                if (k > 0) //propagacja
                {
                    //obliczanie macierzy do diagonalizacji
                    for (int i = 0; i < Nx; ++i)
                    {
                        A[i] = -S2 / dx;
                        B[i] = 2 * dx / dt + 2 * S2 / dx - dx * S0(x(i));
                        C[i] = -S2 / dx; //CZY TU POWINIEN BYC MINUS?????????????????
                        D[i] = Psi[i] * (2 * dx / dt - 2 * S2 / dx + dx * S0(x(i)));
                        if (i < Nx - 1) D[i] += Psi[i + 1] * S2 / dx;
                        if (i > 0) D[i] += Psi[i - 1] * S2 / dx;
                    }

                    A[Nx - 1] = 0;
                    C[0] = 0;

                    //rozwiązywanie układu równań trójprzekątniowych
                    try
                    {
                        UkladTrojprzekatniowy.rozw3p(Nx, A, B, C, D, Psi);
                    }
                    catch (Exception exc)
                    {
                        Console.Error.WriteLine("Wywaliło się: " + exc.Message);
                        System.Environment.Exit(1);
                    }
                }

                //obliczanie zależnych od czasu wartości
                norma = 0;
                double położenie = 0;
                double _norma = 0; //Uwaga! Używane tylko w pętli
                for (int i = 0; i < Nx; ++i)
                {
                    _norma = Psi[i].Norm();
                    norma += _norma;
                    położenie += x(i) * _norma;
                }
                norma *= dx;
                położenie *= dx;

                Console.WriteLine(k.ToString(formatProvider) + "\t" + t(k).ToString(formatProvider) + "\t" + norma.ToString(formatProvider) + "\t" + położenie.ToString(formatProvider));
            }

            Console.WriteLine("\n\nOK.\n\n");
        }
    }
}
